/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype.factory;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.LazyEvaluatedEREDate;
import com.ericsson.ere.defs.ClassRepositoryUser;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.parser.DefaultExpressionParserHandler;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.selectiontree.modifiers.mfo.ResolvingInfixExpressionFormatter;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;

public class LazyEvaluatedEREDateClassFactory
implements ValueClassFactory,
ClassRepositoryUser {
    private ClassRepository myRepository;
    private FieldDefinition myField;

    @Override
    public Object createDefaultInstance() {
        EREDate date = EREDateFactory.today();
        return date;
    }

    public LazyEvaluatedEREDateClassFactory createCopyWithField(FieldDefinition def) {
        LazyEvaluatedEREDateClassFactory newFactory = new LazyEvaluatedEREDateClassFactory();
        newFactory.myRepository = this.myRepository;
        newFactory.myField = def;
        return newFactory;
    }

    @Override
    public String makeDisplayString(Object anObject) {
        String result;
        if (anObject instanceof LazyEvaluatedEREDate) {
            assert (this.myRepository != null) : "Need a class repository at this point in LazyEvaluatedEREDateClassFactory.";
            LazyEvaluatedEREDate theLazyObj = (LazyEvaluatedEREDate)anObject;
            String str = theLazyObj.getExpressionString();
            ExpressionParser parser = new ExpressionParser(new DefaultExpressionParserOptions(), new DefaultExpressionParserHandler(this.myRepository, null));
            try {
                Expression expr = parser.parse(str);
                result = ResolvingInfixExpressionFormatter.format(expr, this.createDataSet(this.myRepository), ResolvingInfixExpressionFormatter.ResolutionLevel.NONE);
            }
            catch (Exception ex) {
                result = "<Error in expression: " + ex.getMessage() + ">";
            }
        } else if (anObject instanceof EREDate) {
            result = EREDateUtil.isBoundaryDate(anObject) && this.myField != null ? EREDateUtil.getDisplayableStringForEREDateConstant((EREDate)anObject, this.myField) : anObject.toString();
        } else {
            throw new IllegalArgumentException("Unknown object type: " + anObject);
        }
        return result;
    }

    private DataSet createDataSet(ClassRepository repository) {
        DataSetFactory factory = repository.getDataSetFactory();
        return factory.createDataSet();
    }

    @Override
    public String makeValueString(Object anObject) {
        if (anObject instanceof LazyEvaluatedEREDate) {
            LazyEvaluatedEREDate theLazyObj = (LazyEvaluatedEREDate)anObject;
            return theLazyObj.getExpressionString();
        }
        if (anObject instanceof EREDate) {
            String dateStr = DateUtil.formatISODate((EREDate)anObject);
            return dateStr + "O";
        }
        throw new IllegalArgumentException("Unknown object type: " + anObject);
    }

    @Override
    public Object parseValueString(String aString) {
        EREDate date;
        try {
            date = EREDateFactory.parseDateString(aString);
        }
        catch (IllegalArgumentException ex) {
            date = new LazyEvaluatedEREDate(aString);
        }
        return date;
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
        if (this.myRepository != null) {
            throw new IllegalStateException("A class repository has already been set for this object.");
        }
        if (rep == null) {
            throw new IllegalArgumentException("Non-null class repository is required.");
        }
        this.myRepository = rep;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LazyEvaluatedEREDateClassFactory other = (LazyEvaluatedEREDateClassFactory)obj;
        return !(this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository));
    }
}

