/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.SplashScreenPanel;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.ProgressVisualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;

public class SplashScreen2
extends JWindow
implements ProgressVisualizer {
    JProgressBar progress;
    JLabel message;
    int maxProgress;
    int currentProgress;
    JPanel basePanel;
    private JLabel copyRightLabel;
    private JPanel bottom;
    private JPanel stretchPanel;

    public SplashScreen2(int maxSteps) {
        super(new JFrame("Splash"));
        this.maxProgress = maxSteps;
        this.basePanel = new SplashScreenPanel();
        this.progress = new JProgressBar(this.currentProgress, this.maxProgress);
        this.progress.setBorderPainted(false);
        this.progress.setForeground(new Color(51, 102, 153));
        if (RmaDefs.getStringResource("splash.indeterminate").toLowerCase().equals("yes")) {
            this.progress.setIndeterminate(true);
        } else {
            this.progress.setStringPainted(true);
        }
        JPanel progressPanel = new JPanel();
        progressPanel.setBackground(Color.white);
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        progressPanel.add(Box.createHorizontalStrut(11));
        progressPanel.add(this.progress);
        progressPanel.add(Box.createHorizontalStrut(11));
        this.stretchPanel = new JPanel(new GridBagLayout());
        this.stretchPanel.setBackground(Color.WHITE);
        this.message = new JLabel("   ");
        this.message.setFont(new Font("Arial", 0, 9));
        this.message.setForeground(new Color(102, 102, 102));
        this.copyRightLabel = new JLabel(RmaDefs.getStringResource("app.copyright.label"));
        this.copyRightLabel.setFont(new Font("Arial", 0, 9));
        this.copyRightLabel.setForeground(Color.BLACK);
        this.copyRightLabel.setBackground(Color.BLACK);
        this.bottom = new JPanel(new GridBagLayout());
        this.bottom.setBackground(Color.WHITE);
        this.bottom.add((Component)this.stretchPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.bottom.add((Component)progressPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 0, 5, 0), 0, 0));
        this.stretchPanel.add((Component)this.message, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.bottom.add((Component)this.stretchPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.bottom.add((Component)this.copyRightLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 10, 5), 0, 0));
        this.bottom.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() % 2 == 0) {
                    // empty if block
                }
            }
        });
        JPanel pane = new JPanel(new GridBagLayout());
        pane.add((Component)this.basePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pane.add((Component)this.bottom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pane.setBorder(new BevelBorder(3, Color.black, Color.black));
        this.getContentPane().add(pane);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.setVisible(true);
    }

    public void dismiss() {
        this.dispose();
    }

    public ProgressIndicator[] getProgressIndicator(int slices) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this.maxProgress, this);
        return handler.splitProgress(slices);
    }

    public ProgressIndicator[] getProgressIndicator(int[] slices) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this.maxProgress, this);
        return handler.splitProgress(slices);
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setConfirmBeforeExit() {
    }

    @Override
    public void setInfoText(String text) {
        if (text != null) {
            this.message.setText(text);
        }
    }

    @Override
    public void setProgressGoal(int goal) {
        this.progress.setMinimum(0);
        this.progress.setMaximum(goal);
    }

    @Override
    public void setValue(int value) {
        this.progress.setValue(value);
    }

    @Override
    public void showAdditionalInfo(String text) {
    }
}

