/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.TariffDAGModelAddPolicy;
import ericsson.ere.interfaces.TariffStructureNode;

public class DefaultTariffDAGModelAddPolicy
implements TariffDAGModelAddPolicy {
    private static final TariffDAGModelAddPolicy.AddMode[][][] ADD_DEFAULT_POLICY_MATRIX = new TariffDAGModelAddPolicy.AddMode[][][]{{new TariffDAGModelAddPolicy.AddMode[0], {TariffDAGModelAddPolicy.AddMode.ADD_AS_CHILD}, new TariffDAGModelAddPolicy.AddMode[0], new TariffDAGModelAddPolicy.AddMode[0]}, {new TariffDAGModelAddPolicy.AddMode[0], {TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}, {TariffDAGModelAddPolicy.AddMode.ADD_AS_CHILD, TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}, {TariffDAGModelAddPolicy.AddMode.ADD_AS_CHILD, TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}}, {new TariffDAGModelAddPolicy.AddMode[0], {TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}, {TariffDAGModelAddPolicy.AddMode.ADD_AS_CHILD, TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}, {TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}}, {new TariffDAGModelAddPolicy.AddMode[0], {TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}, new TariffDAGModelAddPolicy.AddMode[0], {TariffDAGModelAddPolicy.AddMode.ADD_AS_CHILD, TariffDAGModelAddPolicy.AddMode.ADD_AS_SIBLING}}};

    @Override
    public boolean getAllowAddAsChild(TariffStructureNode parent, int nodeToAddType, int preferredIndex) {
        if (parent.getChildCount() > 0 && preferredIndex > 0) {
            TariffStructureNode existingChild = null;
            existingChild = preferredIndex < parent.getChildCount() ? (TariffStructureNode)parent.getChildAt(preferredIndex - 1) : (TariffStructureNode)parent.getChildAt(parent.getChildCount() - 1);
            switch (existingChild.getNodeType()) {
                case 1: 
                case 3: {
                    if (nodeToAddType != 2) break;
                    return false;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }

    @Override
    public TariffDAGModelAddPolicy.AddMode[] getDefaultAddPolicy(TariffStructureNode parentNode, TariffStructureNode nodeToAdd) {
        return ADD_DEFAULT_POLICY_MATRIX[parentNode.getNodeType()][nodeToAdd.getNodeType()];
    }

    @Override
    public int getIndexForChild(TariffStructureNode parent, TariffStructureNode nodeToAdd, int preferredIndex) {
        int childCount = parent.getChildCount();
        int lastConditionIndex = this.getIndexForLastChildCondition(parent);
        switch (nodeToAdd.getNodeType()) {
            case 2: {
                if (lastConditionIndex < 0) {
                    return 0;
                }
                if (preferredIndex <= lastConditionIndex + 1) {
                    return preferredIndex;
                }
                return lastConditionIndex + 1;
            }
            case 1: 
            case 3: {
                if (preferredIndex <= lastConditionIndex + 1) {
                    return lastConditionIndex + 1;
                }
                if (preferredIndex >= childCount) {
                    return childCount;
                }
                return preferredIndex;
            }
        }
        throw new AssertionError();
    }

    private int getIndexForLastChildCondition(TariffStructureNode parent) {
        int childCount = parent.getChildCount();
        int foundIndex = -1;
        int i = 0;
        while (i < childCount) {
            if (((TariffStructureNode)parent.getChildAt(i)).getNodeType() != 2) {
                foundIndex = i - 1;
                break;
            }
            foundIndex = i++;
        }
        return foundIndex;
    }
}

