/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.defs.STQRepositories;
import com.ericsson.ere.defs.STQRepository;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.ClassProfile;

public class STQPredicate
implements NodePredicate {
    static final long serialVersionUID = 1L;
    public static final int EQUALS = 0;
    public static final int CONTAINS = 1;
    public static final int STARTS_WITH = 2;
    public static final int ENDS_WITH = 3;
    private final String myQualifierToMatch;
    private final int myOperatorId;

    public STQPredicate(String stqToMatch, int operatorIndex) {
        this.myQualifierToMatch = stqToMatch;
        this.myOperatorId = operatorIndex;
    }

    @Override
    public boolean test(TariffDAGNode node) {
        if (node instanceof TSNode) {
            TSNode currentTSNode = (TSNode)node;
            ClassProfile classProfile = currentTSNode.getClassProfile();
            STQRepository stqRepository = STQRepositories.getRepositoryForTreeModel(currentTSNode.getTreeModel());
            SelectionTreeQualifier currentStq = stqRepository.getSTQFor(classProfile);
            if (currentStq == null) {
                return false;
            }
            return this.checkIfSTQMatches(currentStq);
        }
        return false;
    }

    private boolean checkIfSTQMatches(SelectionTreeQualifier stq) {
        switch (this.myOperatorId) {
            case 0: {
                try {
                    SelectionTreeQualifier qualifierToMatch = SelectionTreeQualifier.valueOf(this.myQualifierToMatch);
                    return qualifierToMatch.equals(stq);
                }
                catch (IllegalArgumentException nfe) {
                    return false;
                }
            }
            case 1: {
                return String.valueOf(stq).contains(this.myQualifierToMatch);
            }
            case 3: {
                return String.valueOf(stq).endsWith(this.myQualifierToMatch);
            }
            case 2: {
                return String.valueOf(stq).startsWith(this.myQualifierToMatch);
            }
        }
        throw new UnsupportedOperationException("The operation is not supported in this predicate.");
    }

    public String getQualifier() {
        return this.myQualifierToMatch;
    }

    public int getOperator() {
        return this.myOperatorId;
    }
}

