/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.simulation;

import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.interfaces.SimImporter;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.simulation.ParameterModel;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.Service;
import ericsson.vareditor.VarTableCellEditor;
import ericsson.vareditor.VarTableCellRenderer;
import ericsson.vareditor.VarTableUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RatingDataPanel
extends JPanel {
    private JTable myBasicDataTable;
    private JTable myInputDataTable;
    private JTable myOutputDataTable;
    private Service myService;
    private ClassRepository myClassRepository;
    static String LABEL_START_TIME = "Start time";
    static String LABEL_MAX_COST = "Max cost";
    static String LABEL_EXPECTED_DURATION = "Expected duration";
    static String LABEL_EXPECTED_COST = "Expected cost";
    public static final String TAG_EXPECTED_DURATION = '\u000b' + LABEL_EXPECTED_DURATION + '\u000b';
    public static final String TAG_EXPECTED_COST = '\u000b' + LABEL_EXPECTED_COST + '\u000b';
    private Map<String, SimulationEditor> myEditorMap;
    public static final String LABEL_DESCRIPTION = "Description";
    private String myDescription;
    private PropertyChangeSupport myPropSupport;

    public RatingDataPanel(Service service) throws Exception {
        this.myService = service;
        this.myClassRepository = service.getClassRepository();
        this.myPropSupport = new PropertyChangeSupport(this);
        this.setLayout(new BorderLayout());
        JSplitPane basicPanel = new JSplitPane(0);
        basicPanel.setDividerSize(8);
        basicPanel.setOneTouchExpandable(true);
        List<Variable> basicVariables = this.buildBasicVariables();
        List<Variable> inputVariables = this.buildInputVariables();
        List<Variable> outputVariables = this.buildOutputVariables();
        int basicLen = basicVariables.size();
        int inputLen = inputVariables.size();
        int outputLen = outputVariables.size();
        double len = 1.0 * (double)(basicLen + inputLen + outputLen);
        basicPanel.setResizeWeight((double)basicLen / len);
        ArrayList<Boolean> basicOnOffList = new ArrayList<Boolean>(basicLen);
        for (int i = 0; i < basicLen; ++i) {
            Variable v = basicVariables.get(i);
            String label = v.getLabel();
            Boolean result = Boolean.TRUE;
            if (label.equalsIgnoreCase(LABEL_EXPECTED_DURATION) || label.equalsIgnoreCase(LABEL_EXPECTED_COST)) {
                result = Boolean.FALSE;
            }
            basicOnOffList.add(result);
        }
        ArrayList<Boolean> inputOnOffList = new ArrayList<Boolean>(inputLen);
        Map<String, FieldDefinition> inputFieldMap = this.myClassRepository.getInputFieldDefinitionMap();
        for (int i = 0; i < inputLen; ++i) {
            Variable v = inputVariables.get(i);
            String name = v.getLabel();
            FieldDefinition def = inputFieldMap.get(name);
            if (def.isMandatory()) {
                inputOnOffList.add(Boolean.TRUE);
                continue;
            }
            inputOnOffList.add(Boolean.FALSE);
        }
        ArrayList<Boolean> outputOnOffList = new ArrayList<Boolean>(outputLen);
        for (int i = 0; i < outputLen; ++i) {
            outputOnOffList.add(Boolean.FALSE);
        }
        this.myBasicDataTable = new JTable(new ParameterModel(basicVariables, basicOnOffList));
        this.configJTable(this.myBasicDataTable);
        this.myInputDataTable = new JTable(new ParameterModel(inputVariables, inputOnOffList));
        this.configJTable(this.myInputDataTable);
        this.myOutputDataTable = new JTable(new ParameterModel(outputVariables, outputOnOffList));
        this.configJTable(this.myOutputDataTable);
        this.myBasicDataTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() == 0) {
                    String oldDescr = RatingDataPanel.this.myDescription;
                    RatingDataPanel.this.myDescription = RatingDataPanel.this.myBasicDataTable.getValueAt(0, 2).toString();
                    RatingDataPanel.this.myPropSupport.firePropertyChange(RatingDataPanel.LABEL_DESCRIPTION, oldDescr, RatingDataPanel.this.myDescription);
                }
            }
        });
        JSplitPane inoutPanel = new JSplitPane(0);
        inoutPanel.setDividerSize(8);
        inoutPanel.setOneTouchExpandable(true);
        inoutPanel.setResizeWeight((double)inputLen / (double)(inputLen + outputLen));
        inoutPanel.setTopComponent(new JScrollPane(this.myInputDataTable));
        inoutPanel.setBottomComponent(new JScrollPane(this.myOutputDataTable));
        basicPanel.setTopComponent(new JScrollPane(this.myBasicDataTable));
        basicPanel.setBottomComponent(inoutPanel);
        this.add((Component)basicPanel, "Center");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.myPropSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.myPropSupport.removePropertyChangeListener(l);
    }

    private List<Variable> buildInputVariables() throws Exception {
        List<FieldDefinition> fields = this.myClassRepository.getInputFieldDefinitions();
        return this.buildVariablesFromFieldDefinitions(fields);
    }

    private List<Variable> buildOutputVariables() throws Exception {
        List<FieldDefinition> fields = this.myClassRepository.getOutputFieldDefinitions();
        return this.buildVariablesFromFieldDefinitions(fields);
    }

    private List<Variable> buildVariablesFromFieldDefinitions(List<FieldDefinition> fields) throws Exception {
        ArrayList<Variable> variables = new ArrayList<Variable>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            FieldDefinition field = fields.get(i);
            if (!field.hasVariableAttributes()) continue;
            Variable v = null;
            if (field.getSupportArray()) {
                Object[] protoArray = this.createArrayType(field.getDataType());
                String name = field.getVariableAttributes().getNamedItem("Name").getNodeValue();
                Vector<Object> values = new Vector<Object>();
                if (field.hasVariableAttributes() && field.getVariableAttributes().getNamedItem("Default") != null) {
                    String defaultValues = field.getVariableAttributes().getNamedItem("Default").getNodeValue();
                    values.addAll(this.parseValue(defaultValues, field.getDataType()));
                }
                v = new ArrayVariable(name, values.toArray(protoArray));
            } else {
                XMLInitializable editor = field.createUtil("EditComponent");
                if (editor == null) {
                    editor = field.createUtil("InputRestriction");
                }
                if (editor != null) {
                    SimulationEditor e = (SimulationEditor)((Object)editor);
                    e.setFieldDefinition(field);
                    if (this.myEditorMap == null) {
                        this.myEditorMap = new HashMap<String, SimulationEditor>();
                    }
                    NamedNodeMap attr = field.getVariableAttributes();
                    String name = attr.getNamedItem("Name").getNodeValue();
                    this.myEditorMap.put(name, e);
                    v = e.createVariable();
                } else if (field.getDataType().equals("Boolean")) {
                    v = VariableFactory.createBooleanVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Date")) {
                    v = VariableFactory.createDateVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Double")) {
                    v = VariableFactory.createDoubleVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Integer") || field.getDataType().equals("UInteger")) {
                    v = VariableFactory.createIntegerVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Long") || field.getDataType().equals("ULong")) {
                    v = VariableFactory.createLongVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Short")) {
                    v = VariableFactory.createShortVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("UShort")) {
                    v = VariableFactory.createUShortVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("String")) {
                    v = VariableFactory.createStringVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("BcdString")) {
                    v = VariableFactory.createBcdStringVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Decimal")) {
                    v = VariableFactory.createDecimalVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("MonetaryUnits")) {
                    v = VariableFactory.createMonetaryUnitsVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("OctetString")) {
                    v = VariableFactory.createOctetStringVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("Time")) {
                    v = VariableFactory.createTimeVariable(field.getVariableAttributes());
                } else if (field.getDataType().equals("UnsignedInt32")) {
                    v = VariableFactory.createUnsignedInt32Variable(field.getVariableAttributes());
                } else if (field.getDataType().equals("UnsignedInt16")) {
                    v = VariableFactory.createUnsignedInt16Variable(field.getVariableAttributes());
                } else if (field.getDataType().equals("UnsignedInt8")) {
                    v = VariableFactory.createUnsignedInt8Variable(field.getVariableAttributes());
                } else if (field.getDataType().equals("RatingDecimal")) {
                    v = VariableFactory.createRatingDecimalVariable(field.getVariableAttributes());
                } else {
                    System.err.println("RatingDataPanel: Unknown data type: " + field.getDataType());
                }
            }
            if (v == null) {
                System.err.println("RatingDataPanel: Unknown data type: " + field.getDataType());
                continue;
            }
            variables.add(v);
        }
        return variables;
    }

    private List<Variable> buildBasicVariables() {
        ArrayList<Variable> variables = new ArrayList<Variable>(7);
        this.myDescription = "A descriptive text";
        variables.add(new StringVariable(LABEL_DESCRIPTION, this.myDescription));
        variables.add(new IntegerVariable("Duration", 60));
        variables.add(new DoubleVariable(LABEL_MAX_COST, 100.0));
        variables.add(new DateAndTimeVariable(LABEL_START_TIME, DateAndTimeVariable.Content.DATE_TIME));
        variables.add(new LongVariable(LABEL_EXPECTED_DURATION, 0L));
        variables.add(new DoubleVariable(LABEL_EXPECTED_COST, 0.0));
        variables.add(new MultilineStringVariable("Comment", ""));
        return variables;
    }

    private void configJTable(JTable table) {
        table.setDefaultRenderer(Variable.class, new VarTableCellRenderer());
        table.setDefaultEditor(Variable.class, new VarTableCellEditor());
        VarTableUtil.configureTableForVariables(table, 1, 2);
        TableColumn labelColumn = table.getColumnModel().getColumn(1);
        labelColumn.setMaxWidth(labelColumn.getPreferredWidth());
        int width = GuiUtil.getMaxPreferredWidth(table, 0);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMinWidth(width + 4);
        column.setPreferredWidth(width + 8);
        column.setMaxWidth(width + 8);
    }

    public RatingData createRatingData() throws Exception {
        RatingData ratingData = this.myService.getRatingData();
        Map<String, FieldDefinition> fields = this.myClassRepository.getInputFieldDefinitionMap();
        TableModel model = this.myInputDataTable.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            Boolean isUsed = (Boolean)model.getValueAt(row, 0);
            if (isUsed.booleanValue()) {
                Variable v = (Variable)model.getValueAt(row, 2);
                String name = v.getLabel();
                FieldDefinition field = fields.get(name);
                String type = v.getTypename();
                String[] valueObject = new String[1];
                if (type.equalsIgnoreCase("array")) {
                    Object[] o = (Object[])v.getValueObject();
                    ArrayModel mod = (ArrayModel)v.getModel();
                    valueObject = new String[mod.getRowCount()];
                    for (int i = 0; i < o.length; ++i) {
                        if (o[i] != null) {
                            if (o[i] instanceof Date) {
                                valueObject[i] = DateUtil.format((Date)o[i]);
                                continue;
                            }
                            valueObject[i] = o[i].toString();
                            continue;
                        }
                        valueObject[i] = null;
                    }
                    StringTokenizer token = new StringTokenizer(mod.getColumnClass(mod.getColumnCount() - 1).toString(), ".");
                    while (token.hasMoreTokens()) {
                        type = token.nextToken();
                    }
                } else {
                    SimulationEditor ed;
                    type = field.getDataType();
                    String val = v.toString();
                    if (this.myEditorMap != null && (ed = this.myEditorMap.get(name)) != null) {
                        val = ed.getValueForEditString(val);
                    }
                    valueObject[0] = val;
                }
                ratingData.setValues(name, type, valueObject);
                continue;
            }
            String label = (String)model.getValueAt(row, 1);
            ratingData.remove(label);
            ratingData.getUsedValues().remove(label);
        }
        Time time = new Time(DateUtil.format(new Date()));
        model = this.myBasicDataTable.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            Boolean isUsed = (Boolean)model.getValueAt(row, 0);
            if (!isUsed.booleanValue()) continue;
            Variable v = (Variable)model.getValueAt(row, 2);
            String name = v.getLabel();
            Object valueObj = v.getValueObject();
            if (name.equals("Duration")) {
                ratingData.maxDuration = ((Integer)valueObj).intValue();
                continue;
            }
            if (name.equals(LABEL_MAX_COST)) {
                ratingData.maxCost = (Double)valueObj;
                continue;
            }
            if (!name.equals(LABEL_START_TIME)) continue;
            time = (Time)valueObj;
        }
        ratingData.skipTimeCharging = 0;
        ratingData.currentDiscount = 1.0;
        ratingData.startTime = time.getCalendar().getTimeInMillis();
        ratingData.currentStartDate = time.getCalendar();
        ratingData.printAllData();
        return ratingData;
    }

    @Override
    public String getName() {
        if (this.myBasicDataTable == null) {
            return "null";
        }
        return this.myBasicDataTable.getValueAt(0, 2).toString();
    }

    public Map<String, Object> createExpectedResults() {
        String name;
        Variable v;
        Boolean isUsed;
        int row;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RatingData ratingData = this.myService.getRatingData();
        TableModel model = this.myBasicDataTable.getModel();
        int len = model.getRowCount();
        for (row = 0; row < len; ++row) {
            isUsed = (Boolean)model.getValueAt(row, 0);
            if (!isUsed.booleanValue()) continue;
            v = (Variable)model.getValueAt(row, 2);
            name = v.getLabel();
            if (LABEL_EXPECTED_DURATION.equals(name)) {
                result.put(TAG_EXPECTED_DURATION, v.getValueObject());
                continue;
            }
            if (!LABEL_EXPECTED_COST.equals(name)) continue;
            result.put(TAG_EXPECTED_COST, v.getValueObject());
        }
        model = this.myOutputDataTable.getModel();
        len = model.getRowCount();
        for (row = 0; row < len; ++row) {
            isUsed = (Boolean)model.getValueAt(row, 0);
            if (!isUsed.booleanValue()) continue;
            v = (Variable)model.getValueAt(row, 2);
            name = v.getLabel();
            String type = v.getTypename();
            RatingDataField field = ratingData.getRatingDataFieldByName(name);
            String[] valueObject = new String[1];
            if (!type.equalsIgnoreCase("BUTTON")) {
                if (type.equalsIgnoreCase("array")) {
                    Object[] arr = (Object[])v.getValueObject();
                    int l = arr.length;
                    for (int i = 0; i < l; ++i) {
                        field.addValue(arr[i]);
                    }
                } else {
                    SimulationEditor ed;
                    type = field.getDataType();
                    String val = v.toString();
                    if (this.myEditorMap != null && (ed = this.myEditorMap.get(name)) != null) {
                        val = ed.getValueForEditString(val);
                    }
                    valueObject[0] = val;
                    field.setValues(type, valueObject);
                }
            }
            result.put(name, field);
        }
        return result;
    }

    public void save(PrintWriter out) {
        out.println("<RatingDataPanel>");
        ParameterModel model = (ParameterModel)this.myBasicDataTable.getModel();
        model.writeXML(out);
        model = (ParameterModel)this.myInputDataTable.getModel();
        model.writeXML(out);
        model = (ParameterModel)this.myOutputDataTable.getModel();
        model.writeXML(out);
        out.println("</RatingDataPanel>");
    }

    public void init(Node iterator) {
        block15: {
            try {
                if ("RatingDataPanel".equals(iterator.getNodeName())) {
                    NodeList children = iterator.getChildNodes();
                    int childcount = children.getLength();
                    if (childcount < 3) {
                        throw new IllegalArgumentException("Not enough data for RatingDataPanel, childCount = " + new Integer(childcount));
                    }
                    Node basicNode = null;
                    Node inputNode = null;
                    Node outputNode = null;
                    for (int i = 0; i < childcount; ++i) {
                        Node node = children.item(i);
                        if (node.getNodeType() != 1) continue;
                        if (basicNode == null) {
                            basicNode = node;
                            continue;
                        }
                        if (inputNode == null) {
                            inputNode = node;
                            continue;
                        }
                        if (outputNode == null) {
                            outputNode = node;
                            continue;
                        }
                        RmaDefs.loggerSimulator.warning("Unknown node: " + node.getNodeName());
                    }
                    ParameterModel basicModel = ParameterModel.create(basicNode);
                    ArrayList<Diff> inputDiffList = new ArrayList<Diff>();
                    ArrayList<Diff> outputDiffList = new ArrayList<Diff>();
                    ParameterModel readModel = ParameterModel.create(inputNode);
                    List<Variable> variableList = this.buildInputVariables();
                    ParameterModel inputModel = this.mergeSimulatorData(readModel, variableList, inputDiffList);
                    readModel = ParameterModel.create(outputNode);
                    variableList = this.buildOutputVariables();
                    ParameterModel outputModel = this.mergeSimulatorData(readModel, variableList, outputDiffList);
                    this.myBasicDataTable.setModel(basicModel);
                    this.myInputDataTable.setModel(inputModel);
                    this.myOutputDataTable.setModel(outputModel);
                    this.configJTable(this.myBasicDataTable);
                    this.configJTable(this.myInputDataTable);
                    this.configJTable(this.myOutputDataTable);
                    String message = this.getDiffMessage(inputDiffList, outputDiffList);
                    if (!"".equals(message)) {
                        if (message.length() > 3000) {
                            JTextArea textArea = new JTextArea();
                            textArea.setEditable(false);
                            textArea.setText(message);
                            textArea.setBackground(null);
                            JScrollPane scrollPane = new JScrollPane(textArea);
                            scrollPane.setPreferredSize(new Dimension(500, 500));
                            JOptionPane.showMessageDialog(this, scrollPane, "Simulator data changed", 1);
                        } else {
                            DialogFactory.getInformationDialog(this, "Simulator data changed", message);
                        }
                    }
                    break block15;
                }
                SimImporter simloader = null;
                try {
                    String utilName = iterator.getNodeName() + "Importer";
                    XMLInitializable u = this.myClassRepository.createUtil("Simulator", utilName);
                    simloader = (SimImporter)((Object)u);
                }
                catch (Exception x) {
                    simloader = null;
                }
                if (simloader == null) {
                    throw new IllegalArgumentException("Unrecognized node name: " + iterator.getNodeName());
                }
                simloader.setClassRepository(this.myClassRepository);
                simloader.setEditorMap(this.myEditorMap);
                simloader.setBasicVariables(this.buildBasicVariables());
                simloader.setInputVariables(this.buildInputVariables());
                simloader.setOutputVariables(this.buildOutputVariables());
                simloader.build(iterator);
                ParameterModel basicModel = simloader.getBasicModel();
                ParameterModel inputModel = simloader.getInputModel();
                ParameterModel outputModel = simloader.getOutputModel();
                this.myBasicDataTable.setModel(basicModel);
                this.myInputDataTable.setModel(inputModel);
                this.myOutputDataTable.setModel(outputModel);
                this.configJTable(this.myBasicDataTable);
                this.configJTable(this.myInputDataTable);
                this.configJTable(this.myOutputDataTable);
                String message = simloader.getInfoMessage();
                if (message != null && !"".equals(message)) {
                    DialogFactory.getInformationDialog(GuiUtil.getClosestParentOfClass(this, JFrame.class), "Simulator data changed", message);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                String msg = "Failed to open simulator data\nDetails: " + x.toString();
                DialogFactory.getErrorDialog("Failed reading simulator data", msg);
            }
        }
        this.myBasicDataTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() == 0) {
                    String oldDescr = RatingDataPanel.this.myDescription;
                    RatingDataPanel.this.myDescription = RatingDataPanel.this.myBasicDataTable.getValueAt(0, 2).toString();
                    RatingDataPanel.this.myPropSupport.firePropertyChange(RatingDataPanel.LABEL_DESCRIPTION, oldDescr, RatingDataPanel.this.myDescription);
                }
            }
        });
    }

    private Collection<Object> parseValue(String theDefaultValues, String theDataType) {
        StringTokenizer token = new StringTokenizer(theDefaultValues, ";");
        int noOfTokens = token.countTokens();
        ArrayList<Object> values = new ArrayList<Object>(noOfTokens);
        if (theDataType.equals("Boolean")) {
            while (token.hasMoreTokens()) {
                values.add(Boolean.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("Date")) {
            while (token.hasMoreTokens()) {
                Date val = null;
                try {
                    val = DateUtil.stringToDate(token.nextToken(), DateUtil.DATE_TEXT_FORMAT);
                }
                catch (ParseException x) {
                    val = null;
                }
                values.add(val);
            }
        } else if (theDataType.equals("Double")) {
            while (token.hasMoreTokens()) {
                values.add(Double.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("Integer") || theDataType.equals("UInteger")) {
            while (token.hasMoreTokens()) {
                values.add(Integer.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("Long") || theDataType.equals("ULong")) {
            while (token.hasMoreTokens()) {
                values.add(Long.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("Short") || theDataType.equals("UShort")) {
            while (token.hasMoreTokens()) {
                values.add(Short.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("String")) {
            while (token.hasMoreTokens()) {
                values.add(token.nextToken());
            }
        } else if (theDataType.equals("BcdString")) {
            try {
                while (token.hasMoreTokens()) {
                    values.add(BcdString.valueOf(token.nextToken()));
                }
            }
            catch (Exception e) {
                RmaDefs.loggerSimulator.warning("ERROR in ServiceDataArrayDialog can not create BcdString variable for " + token);
            }
        } else if (theDataType.equals("Decimal")) {
            while (token.hasMoreTokens()) {
                values.add(new Decimal(token.nextToken()));
            }
        } else if (theDataType.equals("MonetaryUnits")) {
            while (token.hasMoreTokens()) {
                values.add(new MonetaryUnits(token.nextToken()));
            }
        } else if (theDataType.equals("OctetString")) {
            try {
                while (token.hasMoreTokens()) {
                    values.add(OctetString.valueOf(token.nextToken()));
                }
            }
            catch (Exception e) {
                RmaDefs.loggerSimulator.warning("ERROR in ServiceDataArrayDialog can not create OctetString variable for " + token);
            }
        } else if (theDataType.equals("Time")) {
            while (token.hasMoreTokens()) {
                values.add(new Time(token.nextToken()));
            }
        } else if (theDataType.equals("UnsignedInt32")) {
            while (token.hasMoreTokens()) {
                values.add(UnsignedInt32.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("UnsignedInt16")) {
            while (token.hasMoreTokens()) {
                values.add(UnsignedInt16.valueOf(token.nextToken()));
            }
        } else if (theDataType.equals("UnsignedInt8")) {
            while (token.hasMoreTokens()) {
                values.add(UnsignedInt8.valueOf(token.nextToken()));
            }
        } else {
            RmaDefs.loggerSimulator.warning("DataType " + theDataType + " unknown in ServiceDataArrayDialog.getVariableOfCorrectType(...)");
        }
        return values;
    }

    private Object[] createArrayType(String dataType) {
        if (dataType.equals("Boolean")) {
            return new Boolean[0];
        }
        if (dataType.equals("Date")) {
            return new Date[0];
        }
        if (dataType.equals("Double")) {
            return new Double[0];
        }
        if (dataType.equals("Integer")) {
            return new Integer[0];
        }
        if (dataType.equals("Long")) {
            return new Long[0];
        }
        if (dataType.equals("Short")) {
            return new Short[0];
        }
        if (dataType.equals("UInteger")) {
            return new Integer[0];
        }
        if (dataType.equals("ULong")) {
            return new Long[0];
        }
        if (dataType.equals("UShort")) {
            return new Short[0];
        }
        if (dataType.equals("String")) {
            return new String[0];
        }
        if (dataType.equals("BcdString")) {
            return new BcdString[0];
        }
        if (dataType.equals("Decimal")) {
            return new Decimal[0];
        }
        if (dataType.equals("MonetaryUnits")) {
            return new MonetaryUnits[0];
        }
        if (dataType.equals("OctetString")) {
            return new OctetString[0];
        }
        if (dataType.equals("Time")) {
            return new Time[0];
        }
        if (dataType.equals("UnsignedInt16")) {
            return new UnsignedInt16[0];
        }
        if (dataType.equals("UnsignedInt32")) {
            return new UnsignedInt32[0];
        }
        if (dataType.equals("UnsignedInt8")) {
            return new UnsignedInt8[0];
        }
        return null;
    }

    private ParameterModel mergeSimulatorData(ParameterModel oldModel, List<Variable> variableList, List<Diff> diffList) {
        String label;
        int i;
        ArrayList<Boolean> bools = new ArrayList<Boolean>(variableList.size());
        int len = oldModel.getRowCount();
        for (i = 0; i < len; ++i) {
            Variable savedVar = (Variable)oldModel.getValueAt(i, 2);
            label = savedVar.getLabel();
            Variable serviceVar = VarListUtil.getVariableForName(variableList, label);
            if (serviceVar == null) {
                diffList.add(new Diff(1, savedVar, serviceVar));
                continue;
            }
            this.transferVariableData(savedVar, serviceVar, diffList);
        }
        len = variableList.size();
        for (i = 0; i < len; ++i) {
            Variable serviceVar = variableList.get(i);
            label = serviceVar.getLabel();
            Variable savedVar = this.getVariableFromModel(oldModel, label);
            if (savedVar == null) {
                diffList.add(new Diff(2, savedVar, serviceVar));
                bools.add(Boolean.FALSE);
                continue;
            }
            bools.add(this.getBooleanFromModel(oldModel, label));
        }
        return new ParameterModel(variableList, bools);
    }

    private Variable getVariableFromModel(ParameterModel m, String label) {
        int len = m.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!label.equals(m.getValueAt(i, 1))) continue;
            return (Variable)m.getValueAt(i, 2);
        }
        return null;
    }

    private Boolean getBooleanFromModel(ParameterModel m, String label) {
        int len = m.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!label.equals(m.getValueAt(i, 1))) continue;
            return (Boolean)m.getValueAt(i, 0);
        }
        return null;
    }

    private String getDiffMessage(List<Diff> inputDiffs, List<Diff> outputDiffs) {
        Diff diff;
        int i;
        if (inputDiffs.size() == 0 && outputDiffs.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = inputDiffs.size();
        if (len > 0) {
            buf.append("The following input parameters changed:\n");
            for (i = 0; i < len; ++i) {
                diff = inputDiffs.get(i);
                buf.append(diff.getMessage());
                buf.append("\n");
            }
        }
        if ((len = outputDiffs.size()) > 0) {
            buf.append("\nThe following output parameters changed:\n");
            for (i = 0; i < len; ++i) {
                diff = outputDiffs.get(i);
                buf.append(diff.getMessage());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    private void transferVariableData(Variable from, Variable to, List<Diff> diffList) {
        int toFormat;
        int fromFormat = from.getFormat();
        if (fromFormat == (toFormat = to.getFormat())) {
            if (toFormat == 2 || toFormat == 3 || toFormat == 99) {
                boolean found = this.setValueInComboBoxVariable(from, (DropDownVariable)to);
                if (!found) {
                    diffList.add(new Diff(4, from, to));
                }
            } else {
                to.setValue(from.getValueString());
            }
        } else if (fromFormat == 5000) {
            Object[] val = (Object[])from.getValueObject();
            if (val.length > 0 && val[0] != null) {
                to.setValue(val[0].toString());
            }
            if (val.length == 1) {
                diffList.add(new Diff(3, from, to));
            } else {
                diffList.add(new Diff(4, from, to));
            }
        } else if (toFormat == 2 || toFormat == 3 || toFormat == 99) {
            boolean found = this.setValueInComboBoxVariable(from, (DropDownVariable)to);
            if (found) {
                diffList.add(new Diff(3, from, to));
            } else {
                diffList.add(new Diff(4, from, to));
            }
        } else {
            String fromString = from.toString();
            to.setValue(fromString);
            if (fromString.equals(to.toString())) {
                diffList.add(new Diff(3, from, to));
            } else {
                diffList.add(new Diff(4, from, to));
            }
        }
    }

    private boolean setValueInComboBoxVariable(Variable from, DropDownVariable to) {
        if (from instanceof DropDownVariable) {
            if (((DropDownVariable)from).getSelectedItem() == null) {
                return false;
            }
            to.setSelectedItem(((DropDownVariable)from).getSelectedItem());
        } else {
            if (from.getValueObject() == null) {
                return false;
            }
            to.setSelectedItem(from.getValueObject());
        }
        return to.getValueObject().equals(from.getValueObject());
    }

    public boolean isModified() {
        return ((ParameterModel)this.myBasicDataTable.getModel()).isModified() || ((ParameterModel)this.myInputDataTable.getModel()).isModified() || ((ParameterModel)this.myOutputDataTable.getModel()).isModified();
    }

    public void resetModified() {
        ((ParameterModel)this.myBasicDataTable.getModel()).resetModified();
        ((ParameterModel)this.myInputDataTable.getModel()).resetModified();
        ((ParameterModel)this.myOutputDataTable.getModel()).resetModified();
    }

    static class Diff {
        public static final int NO_DIFF = 0;
        public static final int REMOVED = 1;
        public static final int ADDED = 2;
        public static final int TYPE_CHANGE = 3;
        public static final int VALUE_CHANGE = 4;
        private int myChange = 0;
        private Variable myLeftVar = null;
        private Variable myRightVar = null;

        public Diff(int change, Variable left, Variable right) {
            this.myChange = change;
            this.myLeftVar = left;
            this.myRightVar = right;
        }

        public String getMessage() {
            String msg = null;
            switch (this.myChange) {
                case 0: {
                    msg = "";
                    break;
                }
                case 1: {
                    msg = "The parameter \"" + this.myLeftVar.getLabel() + "\" was removed since it is no longer in use.";
                    break;
                }
                case 2: {
                    msg = "The parameter \"" + this.myRightVar.getLabel() + "\" has been added to the service. Default value: " + this.myRightVar.toString();
                    break;
                }
                case 3: {
                    msg = "The parameter \"" + this.myLeftVar.getLabel() + "\" has changed type. Data may have been lost, new value is: " + this.myRightVar.toString();
                    break;
                }
                case 4: {
                    msg = "The parameter \"" + this.myLeftVar.getLabel() + "\" has changed type and value. New value is: " + this.myRightVar.toString();
                    break;
                }
                default: {
                    msg = "Unknown diff type: " + this.myChange;
                }
            }
            return msg;
        }
    }
}

