/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.simulation.sdp;

import com.ericsson.ere.gui.util.SystemPropertyUtil;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.interfaces.SimImporter;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.simulation.ParameterModel;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.DateUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.Variable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SDPCallImporter
implements XMLInitializable,
SimImporter {
    public final int NO_OF_DED_ACCT = 5;
    public final int NO_OF_ACCUMULATORS = 5;
    public final int NO_OF_EXTENSION_NR = 4;
    private Map<String, SimulationEditor> myEditorMap;
    private List<Variable> myBasicVariables;
    private List<Variable> myInputVariables;
    private List<Variable> myOutputVariables;
    private ParameterModel myBasicModel;
    private ParameterModel myInputModel;
    private ParameterModel myOutputModel;
    private StringBuffer myInfo;

    @Override
    public XMLInitializable init(Node n) {
        return this;
    }

    @Override
    public void setClassRepository(ClassRepository r) {
    }

    @Override
    public void setBasicVariables(List<Variable> l) {
        this.myBasicVariables = l;
    }

    @Override
    public void setInputVariables(List<Variable> l) {
        this.myInputVariables = l;
    }

    @Override
    public void setOutputVariables(List<Variable> l) {
        this.myOutputVariables = l;
    }

    @Override
    public void setEditorMap(Map<String, SimulationEditor> map) {
        this.myEditorMap = map;
    }

    @Override
    public ParameterModel getBasicModel() {
        return this.myBasicModel;
    }

    @Override
    public ParameterModel getInputModel() {
        return this.myInputModel;
    }

    @Override
    public ParameterModel getOutputModel() {
        return this.myOutputModel;
    }

    @Override
    public String getInfoMessage() {
        return this.myInfo == null ? "" : this.myInfo.toString();
    }

    @Override
    public void build(Node node) throws Exception {
        String fromStr;
        String toStr;
        int i;
        this.myInfo = new StringBuffer();
        this.myBasicModel = new ParameterModel(this.myBasicVariables);
        this.myInputModel = new ParameterModel(this.myInputVariables);
        ArrayList<Boolean> bools = new ArrayList<Boolean>(this.myOutputVariables.size());
        int len = this.myOutputVariables.size();
        for (int i2 = 0; i2 < len; ++i2) {
            bools.add(Boolean.FALSE);
        }
        this.myOutputModel = new ParameterModel(this.myOutputVariables, bools);
        NodeList children = node.getChildNodes();
        this.update(this.myBasicModel, "Description", children, "CallDescription");
        this.updateValidDecimals(children);
        this.update(this.myBasicModel, "Duration", children, "CallLength");
        this.update(this.myBasicModel, "Max cost", children, "ValueOnAccount");
        this.updateStartTime(this.myBasicModel, children);
        this.update(this.myBasicModel, "Expected duration", children, "ExpectedDuration");
        this.update(this.myBasicModel, "Expected cost", children, "ExpectedCost");
        this.update(this.myInputModel, "Main account", children, "ValueOnAccount");
        for (int i3 = 0; i3 < 5; ++i3) {
            String toStr2 = "Dedicated account " + (i3 + 1);
            String fromStr2 = "ValueOnSubAccount" + (i3 + 1);
            this.update(this.myInputModel, toStr2, children, fromStr2);
        }
        this.update(this.myInputModel, "Selected dedicated account ID", children, "SubAccountId");
        this.update(this.myInputModel, "Traffic case", children, "TrafficCase");
        this.update(this.myInputModel, "Tele service code", children, "TeleServiceCode");
        this.update(this.myInputModel, "Call event", children, "CallEvent");
        this.update(this.myInputModel, "Called party number", children, "CalledPartyNumber");
        this.update(this.myInputModel, "Calling party number", children, "CallingPartyNumber");
        this.update(this.myInputModel, "Redirecting party number", children, "RedirectingPartyNumber");
        this.update(this.myInputModel, "Orig. location info", children, "OriginatingVLRNumber");
        this.update(this.myInputModel, "Term. location info", children, "TerminatingVLRNumber");
        this.update(this.myInputModel, "Network ID", children, "RCO");
        boolean rcoFound = this.getIsUsed(this.myInputModel, "Network ID");
        this.update(this.myInputModel, "Network ID", children, "NetworkID");
        if (!this.getIsUsed(this.myInputModel, "Network ID") && rcoFound) {
            this.setIsUsed(this.myInputModel, "Network ID", true);
        }
        this.update(this.myInputModel, "Service class", children, "ServiceClass");
        this.update(this.myInputModel, "Subscription type", children, "SubscriptionType");
        this.update(this.myInputModel, "Service provider ID", children, "ServiceProviderID");
        this.update(this.myInputModel, "Unit type", children, "UnitType");
        this.update(this.myInputModel, "FaF indicator", children, "FaF");
        this.update(this.myInputModel, "GPRS quality of service", children, "GPRSQoS");
        this.update(this.myInputModel, "SMS delivery status", children, "SMSDeliveryStatus");
        for (i = 0; i < 4; ++i) {
            toStr = "Extension number " + (i + 1);
            fromStr = "ExtensionNr" + (i + 1);
            this.update(this.myInputModel, toStr, children, fromStr);
        }
        this.update(this.myInputModel, "Extension text", children, "ExtensionText");
        for (i = 0; i < 5; ++i) {
            toStr = "Accumulator " + (i + 1) + " activated";
            fromStr = "Accumulator" + (i + 1) + "Valid";
            this.update(this.myInputModel, toStr, children, fromStr);
            toStr = "Accumulator " + (i + 1) + " value";
            fromStr = "Accumulator" + (i + 1) + "Value";
            this.update(this.myInputModel, toStr, children, fromStr);
        }
        this.update(this.myInputModel, "Selected accumulator", children, "ActiveAccumulator");
        this.update(this.myOutputModel, "Call setup code", children, "???");
        this.update(this.myOutputModel, "Counter increase", children, "ExpectedAccumulatorChange");
        this.update(this.myOutputModel, "Selected Accumulator", children, "ExpectedSelectedAccumulator");
        NodeList bonusChildren = children;
        Element expBonusNode = XMLUtil.getNamedElement("ExpectedBonusResult", children);
        if (expBonusNode != null) {
            bonusChildren = expBonusNode.getChildNodes();
        }
        this.update(this.myOutputModel, "Bonus Main account", bonusChildren, "ExpectedBonusMain");
        expBonusNode = XMLUtil.getNamedElement("ExpectedBonusDedAcc", bonusChildren);
        if (expBonusNode != null) {
            for (int i4 = 0; i4 < 5; ++i4) {
                String tagName = "ExpectedBonusAcc" + (i4 + 1);
                Element expBonusAcctNode = XMLUtil.getNamedElement(tagName, expBonusNode.getChildNodes());
                if (expBonusAcctNode == null) continue;
                NodeList c = expBonusAcctNode.getChildNodes();
                String toStr3 = "Bonus dedicated account " + (i4 + 1);
                String fromStr3 = "ExpectedBonus";
                this.update(this.myOutputModel, toStr3, c, fromStr3);
                toStr3 = "Expiry type dedicated account " + (i4 + 1);
                fromStr3 = "ExpectedExpiryType";
                this.update(this.myOutputModel, toStr3, c, fromStr3);
                toStr3 = "Expiry change dedicated account " + (i4 + 1);
                fromStr3 = "ExpectedExpiryChange";
                this.update(this.myOutputModel, toStr3, c, fromStr3);
            }
        }
        NodeList accDeltaChildren = bonusChildren;
        Element expBonusAccNode = XMLUtil.getNamedElement("ExpectedBonusAccDelta", bonusChildren);
        if (expBonusAccNode != null) {
            accDeltaChildren = expBonusAccNode.getChildNodes();
        }
        for (int i5 = 0; i5 < 5; ++i5) {
            String toStr4 = "Accumulator delta " + (i5 + 1);
            String fromStr4 = "DeltaAcc" + (i5 + 1);
            this.update(this.myOutputModel, toStr4, accDeltaChildren, fromStr4);
        }
    }

    private void updateValidDecimals(NodeList nodes) {
        Element decNode = XMLUtil.getNamedElement("ValidDecInResult", nodes);
        if (decNode != null) {
            String oldVal = SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix("sdp.sim.noOfDecimals", "3");
            String decString = XMLUtil.getFirstTextContent(decNode);
            if (decString != null && !"".equals(decString)) {
                try {
                    int i = Integer.parseInt(decString);
                    if (i >= 0 && i <= 10) {
                        System.setProperty("sdp.sim.noOfDecimals", decString);
                    } else {
                        this.myInfo.append("Valid number of decimals out of range. Using default value: " + oldVal + "\n");
                    }
                }
                catch (NumberFormatException x) {
                    this.myInfo.append("Could not determine number of valid decimals. Using default value: " + oldVal + "\n");
                }
            }
        }
    }

    private void updateStartTime(ParameterModel model, NodeList nodes) {
        Element dateNode = XMLUtil.getNamedElement("StartDate", nodes);
        Element timeNode = XMLUtil.getNamedElement("StartTime", nodes);
        if (dateNode != null && timeNode != null) {
            String varName = "Start time";
            String startTime = XMLUtil.getFirstTextContent(dateNode) + " " + XMLUtil.getFirstTextContent(timeNode);
            Variable v = this.getNamedVariable(model, varName);
            if (v == null) {
                System.out.println("Variable " + varName + " not found in model. Ignoring value \"" + startTime + "\"");
                return;
            }
            this.setIsUsed(model, varName, true);
            try {
                Calendar c = DateUtil.stringToCalendar(startTime);
                v.setValue(new Time(c));
            }
            catch (ParseException x) {
                this.myInfo.append("Could not parse start time \"" + startTime + "\" to a valid date. Using current time instead.\n");
            }
            if (!v.toString().equals(startTime)) {
                System.err.println("ERROR: Set value: " + startTime + " but stored value " + v.toString() + " for variable named: " + varName);
            }
        } else {
            this.myInfo.append("Unable to determine start date and time. Using current time instead.\n");
        }
    }

    private void update(ParameterModel model, String varName, NodeList nodes, String nodeName) {
        Variable v = this.getNamedVariable(model, varName);
        Element node = XMLUtil.getNamedElement(nodeName, nodes);
        if (node != null) {
            String value = XMLUtil.getFirstTextContent(node);
            if (value == null || "".equals(value)) {
                return;
            }
            if (v == null) {
                System.out.println("Variable " + varName + " not found in model. Ignoring value \"" + value + "\" for parameter: " + nodeName);
                return;
            }
            this.setIsUsed(model, varName, true);
            SimulationEditor ed = this.myEditorMap.get(varName);
            if (ed != null) {
                if (ed.isValidValueString(value)) {
                    String editValue = ed.getEditStringForValue(value);
                    v.setValue(editValue);
                } else {
                    this.myInfo.append("Parameter \"");
                    this.myInfo.append(varName);
                    this.myInfo.append("\" value out of allowed range, using default (");
                    this.myInfo.append(v.toString());
                    this.myInfo.append(") instead.\n");
                }
            } else {
                v.setValue(value);
                if (!v.toString().equals(value)) {
                    System.err.println("ERROR: Set value: " + value + " but stored value " + v.toString() + " for variable named: " + varName);
                }
            }
        } else if (v != null) {
            this.setIsUsed(model, varName, false);
        }
    }

    private Variable getNamedVariable(ParameterModel m, String name) {
        int len = m.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!name.equals(m.getValueAt(i, 1))) continue;
            return (Variable)m.getValueAt(i, 2);
        }
        return null;
    }

    private boolean getIsUsed(ParameterModel m, String name) {
        int len = m.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!name.equals(m.getValueAt(i, 1))) continue;
            return (Boolean)m.getValueAt(i, 0);
        }
        return false;
    }

    private void setIsUsed(ParameterModel m, String name, boolean onOff) {
        int len = m.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!name.equals(m.getValueAt(i, 1))) continue;
            if (onOff) {
                m.setValueAt(Boolean.TRUE, i, 0);
            } else {
                m.setValueAt(Boolean.FALSE, i, 0);
            }
            return;
        }
    }
}

