/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SystemPropertiesPane
extends JPanel
implements Printable,
Pageable {
    private static final int POINTS_PER_INCH = 72;
    private String key;
    private String myValue;
    private int keyWidth;
    private int newKeyWidth;
    private int valueWidth;
    private int newValueWidth;
    private JTable myTable;
    private JLabel allMemLabel;
    private JLabel allMemField;
    private JLabel usedMemLabel;
    private JLabel usedMemField;
    private long usedMem;
    private double percent;
    private DecimalFormat d = new DecimalFormat("###.##");
    private PageFormat myPageFormat;
    private Properties mySystemProperties;
    private long myTotalMemory;
    private long myFreeMemory;

    public SystemPropertiesPane(Properties systemProperties) {
        long freeMem;
        long totalMem;
        this.mySystemProperties = systemProperties;
        try {
            totalMem = new Long(systemProperties.getProperty("cmg.runtime.memory.total"));
            freeMem = new Long(systemProperties.getProperty("cmg.runtime.memory.free"));
        }
        catch (Exception e) {
            totalMem = 0L;
            freeMem = 0L;
        }
        this.myTotalMemory = totalMem;
        this.myFreeMemory = freeMem;
        this.createPanel(systemProperties, totalMem, freeMem);
    }

    public SystemPropertiesPane(Properties systemProperties, long totalMemory, long freeMemory) {
        this.mySystemProperties = systemProperties;
        this.myTotalMemory = totalMemory;
        this.myFreeMemory = freeMemory;
        this.createPanel(systemProperties, totalMemory, freeMemory);
    }

    public void createPanel(Properties systemProperties, long totalMemory, long freeMemory) {
        JPanel mem = this.getMemoryUsageInfoPanel(totalMemory, freeMemory);
        JPanel prop = this.getRuntimeInfoPanel(systemProperties);
        prop.setPreferredSize(new Dimension(100, 100));
        JButton printButton = this.getPrintButton(this);
        JButton printToFileButton = this.getPrintToFileButton(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)mem, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)prop, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)printButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)printToFileButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
    }

    public void updateMemoryFields(long totalMemory, long freeMemory) {
        this.usedMem = totalMemory - freeMemory;
        this.percent = totalMemory == 0L ? 0.0 : (double)this.usedMem / 1.0 / (double)totalMemory * 100.0;
        this.allMemField.setText(totalMemory / 1024L + " kB");
        this.usedMemField.setText(this.usedMem / 1024L + " kB (" + this.d.format(this.percent) + "%)");
    }

    private JPanel getMemoryUsageInfoPanel(long totalMemory, long freeMemory) {
        this.usedMem = totalMemory - freeMemory;
        this.percent = totalMemory == 0L ? 0.0 : (double)this.usedMem / 1.0 / (double)totalMemory * 100.0;
        this.allMemLabel = new JLabel(RmaDefs.getStringResource("SystemPropertiesPane.allocatedMem"));
        this.allMemField = new JLabel(totalMemory / 1024L + " kB");
        this.usedMemLabel = new JLabel(RmaDefs.getStringResource("SystemPropertiesPane.usedMem"));
        this.usedMemField = new JLabel(this.usedMem / 1024L + " kB (" + this.d.format(this.percent) + "%)");
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbl.setConstraints(this.allMemLabel, gbc);
        panel.add(this.allMemLabel);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbl.setConstraints(this.allMemField, gbc);
        panel.add(this.allMemField);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbl.setConstraints(this.usedMemLabel, gbc);
        panel.add(this.usedMemLabel);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbl.setConstraints(this.usedMemField, gbc);
        panel.add(this.usedMemField);
        JPanel returnPanel = new JPanel(new BorderLayout());
        returnPanel.setBorder(new TitledBorder(RmaDefs.getStringResource("SystemPropertiesPane.memoryBorderTitle")));
        returnPanel.add((Component)panel, "West");
        return returnPanel;
    }

    private JPanel getRuntimeInfoPanel(Properties props) {
        JPanel panel = new JPanel(new BorderLayout());
        ArrayList<String> al = new ArrayList<String>(props.stringPropertyNames());
        this.myTable = new JTable(al.size(), 2);
        this.myTable.setAutoResizeMode(0);
        Collections.sort(al);
        Iterator<String> it = al.iterator();
        FontMetrics metrics = this.myTable.getFontMetrics(this.myTable.getFont());
        this.keyWidth = metrics.stringWidth(RmaDefs.getStringResource("SystemPropertiesPane.propertyHeader"));
        this.valueWidth = metrics.stringWidth(RmaDefs.getStringResource("SystemPropertiesPane.valueHeader"));
        int i = 0;
        while (it.hasNext()) {
            this.key = it.next();
            this.newKeyWidth = metrics.stringWidth(this.key);
            if (this.newKeyWidth > this.keyWidth) {
                this.keyWidth = this.newKeyWidth;
            }
            this.myTable.setValueAt(this.key, i, 0);
            this.myValue = props.getProperty(this.key);
            this.newValueWidth = metrics.stringWidth(this.myValue);
            if (this.newValueWidth > this.valueWidth) {
                this.valueWidth = this.newValueWidth;
            }
            this.myTable.setValueAt(this.myValue, i, 1);
            ++i;
        }
        this.myTable.getTableHeader().setDefaultRenderer(new RowHeaderRenderer(this.myTable));
        this.myTable.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(RmaDefs.getStringResource("SystemPropertiesPane.propertyHeader"));
        this.myTable.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(RmaDefs.getStringResource("SystemPropertiesPane.valueHeader"));
        this.myTable.getTableHeader().getColumnModel().getColumn(0).setPreferredWidth(this.keyWidth);
        this.myTable.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(this.valueWidth);
        this.myTable.setRequestFocusEnabled(true);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setDefaultEditor(this.myTable.getColumnClass(0), null);
        this.myTable.setDefaultRenderer(this.myTable.getColumnClass(0), new DefaultRenderer());
        this.myTable.addMouseListener(new MouseAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) return;
                try {
                    String cell = SystemPropertiesPane.this.myTable.getValueAt(SystemPropertiesPane.this.myTable.getSelectedRow(), 1).toString();
                    if (!cell.trim().startsWith("http://")) return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JScrollPane jScroll = new JScrollPane();
        jScroll.getViewport().add(this.myTable);
        panel.add((Component)jScroll, "Center");
        panel.setBorder(new TitledBorder(RmaDefs.getStringResource("SystemPropertiesPane.propertyBorderTitle")));
        return panel;
    }

    private JButton getPrintButton(Pageable printObject) {
        JButton printButton = new JButton(RmaDefs.getStringResource("SystemPropertiesPane.printButton"));
        printButton.addActionListener(new PrintActionListener(printObject));
        return printButton;
    }

    private JButton getPrintToFileButton(Pageable printObject) {
        JButton printButton = new JButton(RmaDefs.getStringResource("SystemPropertiesPane.printToFileButton"));
        printButton.addActionListener(new PrintToFileListener(printObject, this));
        return printButton;
    }

    public String getStringFromObject(int row, int column) {
        Object object = this.myTable.getValueAt(row, column);
        return object.toString();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2d.setPaint(Color.black);
        Point2D.Double pen = new Point2D.Double(18.0, 18.0);
        double width = 576.0;
        String text = new String();
        for (int ii = 0; ii < this.myTable.getRowCount(); ++ii) {
            TextLayout layout;
            text = this.getStringFromObject(ii, 0) + " - " + this.getStringFromObject(ii, 1);
            AttributedString paragraphText = new AttributedString(text);
            paragraphText.addAttribute(TextAttribute.FONT, new Font("arial", 0, 10));
            LineBreakMeasurer lineBreaker = new LineBreakMeasurer(paragraphText.getIterator(), new FontRenderContext(null, true, true));
            Vector<TextLayout> lines = new Vector<TextLayout>();
            while ((layout = lineBreaker.nextLayout((float)width)) != null) {
                lines.add(layout);
            }
            for (int i = 0; i < lines.size(); ++i) {
                layout = (TextLayout)lines.get(i);
                pen.y += (double)layout.getAscent();
                layout.draw(g2d, (float)pen.x, (float)pen.y);
                pen.y += (double)(layout.getDescent() + layout.getLeading());
            }
        }
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.myPageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public class RowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        public RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalTextPosition(2);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : " " + value.toString());
            return this;
        }
    }

    public class DefaultRenderer
    implements TableCellRenderer {
        JLabel aLabel = new JLabel();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.aLabel.setText(" " + value.toString());
            }
            this.aLabel.setFont(table.getFont());
            this.aLabel.setOpaque(true);
            if (isSelected) {
                this.aLabel.setForeground(table.getSelectionForeground());
                this.aLabel.setBackground(table.getSelectionBackground());
            } else {
                this.aLabel.setForeground(table.getForeground());
                this.aLabel.setBackground(table.getBackground());
            }
            return this.aLabel;
        }
    }

    public class PrintToFileListener
    implements ActionListener {
        Pageable myPrintObject;
        SystemPropertiesPane myParent;

        public PrintToFileListener(Pageable aPrintObject, SystemPropertiesPane aSystemPropertiesPane) {
            this.myPrintObject = aPrintObject;
            this.myParent = aSystemPropertiesPane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiServiceCenter.getInstance().setFileFilter("txt");
            JFileChooser fileChooser = GuiServiceCenter.getInstance().getFileChooser();
            int returnVal = fileChooser.showSaveDialog(this.myParent);
            if (returnVal == 0) {
                String selectedFile = fileChooser.getSelectedFile().getPath();
                try {
                    File servicePropertiesFile = new File(selectedFile);
                    if (!servicePropertiesFile.exists()) {
                        boolean res = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "File does not exist", "File " + servicePropertiesFile.toString() + " does not exist. Do you want to create it?");
                        if (res) {
                            servicePropertiesFile.createNewFile();
                        } else {
                            return;
                        }
                    }
                    FileOutputStream stream = new FileOutputStream(servicePropertiesFile);
                    SystemPropertiesPane.this.mySystemProperties.store(stream, "SystemProperties, TotalMemory=" + SystemPropertiesPane.this.myTotalMemory + ", FreeMemory=" + SystemPropertiesPane.this.myFreeMemory);
                    stream.close();
                }
                catch (IOException iox) {
                    System.out.println("IOException");
                    iox.printStackTrace();
                }
            }
        }
    }

    public class PrintActionListener
    implements ActionListener {
        Pageable myPrintObject;

        public PrintActionListener(Pageable printObject) {
            this.myPrintObject = printObject;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPageable(this.myPrintObject);
            if (pj.printDialog()) {
                try {
                    SystemPropertiesPane.this.myPageFormat = pj.defaultPage();
                    pj.print();
                }
                catch (Exception PrintException) {
                    PrintException.printStackTrace();
                }
            }
        }
    }
}

