/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.rate.action;

import ericsson.ere.RatingData;
import ericsson.ere.integration.log.DefaultTracer;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.EreAction;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.ServiceProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateAction
extends AbstractAction
implements EreAction {
    private static final String TAG_RATE = "Rate";
    private static final String TAG_FIELD = "Field";
    private static final String ATTR_SERVICEPROVIDER = "ServiceProvider";
    private static final String ATTR_RATINGPLAN = "RatingPlan";
    private static final String ATTR_DATE = "Date";
    private static final String ATTR_DURATION = "Duration";
    private static final String ATTR_COST = "Cost";
    private static final String ATTR_NAME = "Name";
    private static final String ATTR_DATATYPE = "DataType";
    private static final String ATTR_VALUE = "Value";

    @Override
    public String perform(NodeList config) throws Exception {
        StringBuffer buffer = new StringBuffer("");
        for (int ii = 0; ii < config.getLength(); ++ii) {
            if (config.item(ii).getNodeType() != 1 || !config.item(ii).getNodeName().equals(TAG_RATE)) continue;
            try {
                buffer.append(this.performRatingRequest(config.item(ii)).toString());
                continue;
            }
            catch (Exception e) {
                buffer.append("<Error>\n" + e.getMessage() + "\n</Error>\n");
            }
        }
        return buffer.toString();
    }

    private StringBuffer performRatingRequest(Node rateRequest) throws Exception {
        StringBuffer buffer = new StringBuffer();
        try {
            if (!rateRequest.hasAttributes()) {
                throw new Exception("NO attributes for tag <Rate/> missing ");
            }
            buffer.append(this.performRate(rateRequest));
        }
        catch (Exception e) {
            throw new Exception("Error performing rate request due to " + e.getMessage(), e);
        }
        return buffer;
    }

    private StringBuffer performRate(Node rateDetails) throws Exception {
        StringBuffer buffer = new StringBuffer();
        boolean trace = false;
        String serviceProviderName = RateAction.getAttribute(ATTR_SERVICEPROVIDER, rateDetails);
        String ratingPlanName = RateAction.getAttribute(ATTR_RATINGPLAN, rateDetails);
        String date = RateAction.getAttribute(ATTR_DATE, rateDetails);
        String duration = RateAction.getAttribute(ATTR_DURATION, rateDetails);
        String cost = RateAction.getAttribute(ATTR_COST, rateDetails);
        trace = this.getOptionalBooleanAttribute("Trace", rateDetails);
        ServiceProvider serviceProvider = this.getEreManager().getServiceProvider(serviceProviderName);
        if (serviceProvider == null) {
            throw new Exception("ServiceProvider = '" + serviceProviderName + "' is missing");
        }
        RatingPlan ratingPlan = serviceProvider.getRatingPlan(ratingPlanName);
        if (ratingPlan == null) {
            throw new Exception("RatingPlan = '" + ratingPlanName + "' is missing");
        }
        try {
            this.getEreManager().getService(ratingPlan.getService().getId());
        }
        catch (Exception e) {
            throw new Exception("No service for " + ratingPlan.getName(), e);
        }
        RatingData ratingData = this.getEreManager().getService(ratingPlan.getService().getId()).getRatingData();
        ratingData.reset();
        ratingData.setTrace(trace ? new DefaultTracer() : null);
        NodeList parameters = rateDetails.getChildNodes();
        this.fillRatingData(ratingData, parameters, ratingPlan.getService().getId());
        ratingData.rate(serviceProvider, ratingPlan, date, duration, cost);
        if (ratingData.timeLeft == 0L && Long.parseLong(ratingData.getGrantedTime()) == 0L) {
            throw new Exception("Rating failed duration set to zero, not enough money ...");
        }
        if (!ratingData.hasRated) {
            throw new Exception("Rating case not rated ...");
        }
        buffer.append("Rating OK " + ratingData.totalCost + "\n");
        return buffer;
    }

    private void fillRatingData(RatingData ratingData, NodeList parameters, String serviceName) throws Exception {
        for (int ii = 0; ii < parameters.getLength(); ++ii) {
            if (!parameters.item(ii).getNodeName().equals(TAG_FIELD) || !parameters.item(ii).hasAttributes()) continue;
            String fieldName = RateAction.getAttribute(ATTR_NAME, parameters.item(ii));
            String dataType = RateAction.getAttribute(ATTR_DATATYPE, parameters.item(ii));
            String value = RateAction.getAttribute(ATTR_VALUE, parameters.item(ii));
            if (ratingData.getRatingDataFieldByName(fieldName) != null) {
                ratingData.getRatingDataFieldByName(fieldName).setValues(dataType, new String[]{value});
                continue;
            }
            throw new Exception("Field '" + fieldName + "' is not declared in ratingData for service = '" + serviceName + "'");
        }
    }

    private boolean getOptionalBooleanAttribute(String attribute, Node theNode) {
        Element node = (Element)theNode;
        if (node.getAttributes().getNamedItem(attribute) == null) {
            return false;
        }
        return node.getAttributes().getNamedItem(attribute).getNodeValue().equalsIgnoreCase("yes");
    }
}

