/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver.server;

import ericsson.ere.integration.config.ArgumentHandler;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.Loggable;
import ericsson.ere.integration.receiver.server.ServerInterface;
import ericsson.ere.integration.receiver.transport.SocketTransportInterface;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.w3c.dom.Element;

public class SocketServer
implements ServerInterface,
Configurable,
Loggable {
    public static final String TAG_SERVER = "Server";
    public static final String TAG_TRAFFIC_HANDLER = "TrafficHandler";
    public static final String TAG_SESSION_HANDLER = "SessionHandler";
    public static final String ATTR_NAME = "Name";
    private Thread myRunner = null;
    private ServerSocket myServer;
    private Executor myPool = Executors.newCachedThreadPool();
    private EreIntegrationLogInterface myLog = null;
    private int myPort = 9000;
    private SocketTransportInterface myTransportHandler = null;
    private String myName = "NoName";
    volatile boolean shouldStop = false;

    @Override
    public void init(Element root) throws ConfigurationException {
        if (root.getTagName().equals(TAG_SERVER)) {
            this.myName = root.getAttribute(ATTR_NAME);
        }
        try {
            Object obj;
            ArgumentHandler handler = new ArgumentHandler(root);
            if (handler.isArgumentAnInt("Port")) {
                this.myPort = handler.getArgumentAsInt("Port");
            }
            if (handler.hasArgument("TransportHandler") && (obj = handler.getArgument("TransportHandler")) instanceof SocketTransportInterface) {
                this.myTransportHandler = (SocketTransportInterface)obj;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void setLogg(EreIntegrationLogInterface logImpl) {
        this.myLog = logImpl;
    }

    public EreIntegrationLogInterface getLogg() {
        return this.myLog;
    }

    private boolean useLogg() {
        return this.myLog != null;
    }

    public void setTransportHandler(SocketTransportInterface transportHandler) {
        this.myTransportHandler = transportHandler;
    }

    public void startServer(int port) throws IOException {
        this.myPort = port;
        this.startServer();
    }

    @Override
    public void startServer() throws IOException {
        if (this.myRunner == null) {
            this.myRunner = new Thread(this);
            this.myServer = new ServerSocket(this.myPort);
            this.myRunner.start();
            if (this.useLogg() && this.myLog.isLevel(4)) {
                this.myLog.print(4, "SocketServer '" + this.myName + "' started on port " + this.myPort);
            }
        } else if (this.useLogg() && this.myLog.isLevel(2)) {
            this.myLog.print(2, "SocketServer '" + this.myName + "' already started.");
        }
    }

    @Override
    public synchronized void stopServer() {
        if (this.myServer != null) {
            this.shouldStop = true;
            this.myRunner.interrupt();
            this.myRunner = null;
            try {
                this.myServer.close();
            }
            catch (IOException ioe) {
                this.myServer = null;
            }
            if (this.useLogg() && this.myLog.isLevel(4)) {
                this.myLog.print(4, "SocketServer '" + this.myName + "' stopped ");
            }
        } else if (this.useLogg() && this.myLog.isLevel(2)) {
            this.myLog.print(2, "No SocketServer '" + this.myName + "' to stop, already stopped");
        }
    }

    @Override
    public void run() {
        if (this.myServer != null && this.myTransportHandler != null) {
            while (!this.shouldStop) {
                Socket request = null;
                try {
                    request = this.myServer.accept();
                    if (this.useLogg() && this.myLog.isLevel(4)) {
                        this.myLog.print(4, "Connection from " + request.getInetAddress() + " received");
                    }
                    this.myPool.execute(this.myTransportHandler.getSocketTransportObject(request));
                }
                catch (IOException ioe) {
                    if (this.shouldStop && this.useLogg() && this.myLog.isLevel(3)) {
                        this.myLog.print(3, "SocketServer '" + this.myName + "' shutting down, message: \n" + ioe.getMessage());
                        continue;
                    }
                    if (this.shouldStop || !this.useLogg() || !this.myLog.isLevel(1)) continue;
                    this.myLog.print(1, "IOException in SocketServer '" + this.myName + "' run process, message: \n" + ioe.getMessage());
                }
                catch (Exception e) {
                    if (this.useLogg() && this.myLog.isLevel(1)) {
                        this.myLog.print(1, "Exception in SocketServer '" + this.myName + "' run process,  message:\n" + e.getMessage() + "\nconnection from " + request.getInetAddress() + " closed ");
                    }
                    try {
                        if (request == null) continue;
                        request.close();
                    }
                    catch (Exception ee) {
                        if (!this.useLogg() || !this.myLog.isLevel(1)) continue;
                        this.myLog.print(1, "Exception in SocketServer '" + this.myName + "' closing,  message:\n" + ee.getMessage());
                    }
                }
            }
        } else if (this.myTransportHandler == null) {
            System.out.println("Failed to start SocketServer '" + this.myName + "' as no transport handler has been configured.");
        }
    }

    @Override
    public void shutDown() {
        if (this.myRunner == null) {
            if (this.useLogg() && this.myLog.isLevel(2)) {
                this.myLog.print(2, "SocketServer '" + this.myName + "' already shutdown.");
            }
            return;
        }
        this.stopServer();
        this.myPool = null;
        if (this.useLogg() && this.myLog.isLevel(4)) {
            this.myLog.print(4, "SocketServer '" + this.myName + "' shutdown");
        }
    }
}

