/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.modifiers.Rate.class)
public class Rate
extends AbstractModifier {
    double myPrice;
    int myInterval;

    public Rate() {
    }

    public Rate(double thePrice, int theInterval) {
        this.myPrice = thePrice;
        this.myInterval = theInterval;
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) {
        if (theData.skipTimeCharging == 1 || theData.currentMaxDuration == -1L) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tRate.myPrice => " + this.myPrice + "; Do not active during UnsuccCallSetup or for some CDR.  No time to analyse");
            }
        } else {
            double price = this.myPrice * theData.currentDiscount;
            long secs = theData.currentMaxDuration / (long)this.myInterval * (long)this.myInterval;
            if (theData.currentMaxDuration % (long)this.myInterval > 0L) {
                secs += (long)this.myInterval;
            }
            double cost = (double)secs * price / 60.0;
            if (theData.moneyLeft != -1.0 && cost > 0.0 && theData.moneyLeft - cost <= -1.0E-7) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\tNO MORE MONEY TO CONTINUE CALL...");
                }
                secs = (long)(theData.moneyLeft * 60.0 / price);
                secs = secs / (long)this.myInterval * (long)this.myInterval;
                cost = (double)secs * price / 60.0;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\tRate cost = (" + secs + "* (" + this.myPrice + "*" + theData.currentDiscount + ") ) /60 = " + cost);
            }
            theCost.setValue(theCost.value + theData.allocateCost(cost));
            theTime.setValue(theTime.value + theData.allocateTime(secs));
        }
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        double thePrice = 0.0;
        int theChargingInterval = 0;
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("Price".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    thePrice = Double.parseDouble(value.item(bb).getNodeValue());
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("Interval".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theChargingInterval = Integer.parseInt(value.item(bb).getNodeValue());
            }
        }
        this.myPrice = thePrice;
        this.myInterval = theChargingInterval;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myInterval;
        long temp = Double.doubleToLongBits(this.myPrice);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rate other = (Rate)obj;
        if (this.myInterval != other.myInterval) {
            return false;
        }
        return Double.doubleToLongBits(this.myPrice) == Double.doubleToLongBits(other.myPrice);
    }
}

