/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.modifiers.SetVariable.class)
public class SetVariable
extends AbstractModifier {
    String myType;
    String myFieldName;
    Object myValue;
    static final String TAG_VALUE_TYPE = "ValueType";
    static final String TAG_FIELD_NAME = "FieldName";
    static final String TAG_VALUE = "Value";

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String theValueType = "";
        String theFieldName = "";
        String theValue = "";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().equals(TAG_VALUE_TYPE) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theValueType = value.item(bb).getNodeValue();
                }
                if (children.item(aa).getNodeName().equals(TAG_FIELD_NAME) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theFieldName = value.item(bb).getNodeValue();
                }
                if (!children.item(aa).getNodeName().equals(TAG_VALUE) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theValue = value.item(bb).getNodeValue();
            }
        }
        this.myType = theValueType;
        this.myFieldName = theFieldName;
        this.myValue = this.getValue(theValue);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFieldName == null ? 0 : this.myFieldName.hashCode());
        result = 31 * result + (this.myType == null ? 0 : this.myType.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetVariable other = (SetVariable)obj;
        if (this.myFieldName == null ? other.myFieldName != null : !this.myFieldName.equals(other.myFieldName)) {
            return false;
        }
        if (this.myType == null ? other.myType != null : !this.myType.equals(other.myType)) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) {
        if (theData.useTrace()) {
            theData.getTrace().println("\tSET VARIABLE: " + this.myFieldName + " to " + this.myValue.toString());
        }
        String[] values = new String[]{this.myValue.toString()};
        theData.setValues(this.myFieldName, this.myType, values);
    }

    private Object getValue(String theValue) {
        try {
            if (this.myType.equals("UnsignedInt32")) {
                return new UnsignedInt32(Integer.parseInt(theValue));
            }
            if (this.myType.equals("UnsignedInt16")) {
                return new UnsignedInt16(Short.parseShort(theValue));
            }
            if (this.myType.equals("UnsignedInt8")) {
                return new UnsignedInt8(Byte.parseByte(theValue));
            }
            if (this.myType.equals("MonetaryUnits")) {
                return new MonetaryUnits(theValue);
            }
            if (this.myType.equals("Decimal")) {
                return new Decimal(theValue);
            }
            if (this.myType.equals("Time")) {
                return new Time(theValue);
            }
            if (this.myType.equals("String")) {
                return new String(theValue);
            }
            if (!this.myType.equals("BcdString")) {
                if (this.myType.equals("OctetString")) {
                    return new OctetString(theValue);
                }
                if (this.myType.equals("Short")) {
                    return new Short(theValue);
                }
                if (this.myType.equals("Integer")) {
                    return new Integer(theValue);
                }
                if (this.myType.equals("Long")) {
                    return new Long(theValue);
                }
                if (this.myType.equals("Double")) {
                    return new Double(theValue);
                }
                if (this.myType.equals("Boolean")) {
                    return new Boolean(theValue);
                }
                if (this.myType.equals("Date")) {
                    return new Date();
                }
                return new String();
            }
            new BcdString(theValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String();
        }
        return new String();
    }
}

