/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import com.ericsson.ere.mbean.ServiceProviderInfo;
import ericsson.ere.integration.management.util.PropertyContainer;
import ericsson.ere.management.Debug;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EreManager {
    private Map<String, Service> m_services = new HashMap<String, Service>();
    private Map<String, ServiceProvider> m_providerList = new HashMap<String, ServiceProvider>();
    private static final String TAG_NAME = "Manager";
    private String m_name = "Rating Manager";
    private ServiceProviderInfo serviceProviderInfo = new ServiceProviderInfo(this);
    private PropertyContainer myPropertyContainer = new PropertyContainer();

    protected void finalize() throws Throwable {
        this.serviceProviderInfo.unregister();
        super.finalize();
    }

    public PropertyContainer getPropertyContainer() {
        return this.myPropertyContainer;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String aName) {
        this.m_name = aName;
    }

    public void addService(String aName, Service aService) {
        Service sameService = this.getServiceWithNameIgnoreCase(aName);
        if (sameService != null) {
            this.removeService(sameService);
        }
        this.m_services.put(aName, aService);
    }

    public void addServiceProvider(String aName, ServiceProvider aProvider) {
        this.m_providerList.put(aName, aProvider);
    }

    public String toString() {
        return this.m_name;
    }

    public void clearAll() {
        this.m_services = new HashMap<String, Service>();
        this.m_providerList = new HashMap<String, ServiceProvider>();
    }

    public Service createService() throws Exception {
        String serviceName = "* New Service *";
        if (this.containsServiceWithNameIgnoreCase(serviceName)) {
            throw new Exception("Service '" + serviceName + "' or service with name that is interpreted as '" + serviceName + "' already defined");
        }
        Service service = new Service(serviceName);
        this.m_services.put(service.getId(), service);
        return service;
    }

    public int addService(Service aService) {
        Debug.debug(4, "RatingManager:addService()");
        if (this.containsServiceWithNameIgnoreCase(aService.getId())) {
            Debug.debug(3, "RatingManager -- Failed to add Existing Service: " + aService.toString());
            return 1;
        }
        Debug.debug(3, "RatingManager -- No of Services[" + this.m_services.size() + "] before");
        this.addService(aService.getId(), aService);
        Debug.debug(3, "RatingManager -- Add Service: " + aService.toString());
        Debug.debug(3, "RatingManager -- No of Services[" + this.m_services.size() + "] after");
        return 0;
    }

    public boolean containsService(String aServiceId) {
        Debug.debug(4, "RatingManager:containsService()");
        return this.m_services.containsKey(aServiceId);
    }

    public boolean containsServiceCaseInsensitive(String aServiceId) {
        Debug.debug(4, "RatingManager:containsServiceCaseInsesitive()");
        return this.containsServiceWithNameIgnoreCase(aServiceId);
    }

    private Service getServiceWithNameIgnoreCase(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        Service foundService = null;
        String nameToFind = serviceName.trim();
        for (Service aService : this.m_services.values()) {
            if (!nameToFind.equalsIgnoreCase(aService.getId())) continue;
            foundService = aService;
            break;
        }
        return foundService;
    }

    private boolean containsServiceWithNameIgnoreCase(String serviceName) {
        return this.getServiceWithNameIgnoreCase(serviceName) != null;
    }

    public Service getService(String aServiceId) {
        Debug.debug(4, "RatingManager:getService()");
        return this.m_services.get(aServiceId);
    }

    public Collection<Service> getAllServices() {
        Debug.debug(4, "RatingManager:getAllServices()");
        return Collections.unmodifiableCollection(this.m_services.values());
    }

    public int removeService(String aServiceId) {
        Debug.debug(4, "RatingManager:removeService()");
        if (!this.m_services.containsKey(aServiceId)) {
            return 2;
        }
        Debug.debug(3, "RatingManager -- Remove Service: " + aServiceId);
        this.m_services.remove(aServiceId);
        Debug.debug(3, "RatingManager -- No of Services [" + this.m_services.size() + "] after");
        return 0;
    }

    public int removeService(Service aService) {
        return this.removeService(aService.getId());
    }

    public ServiceProvider createServiceProvider() throws Exception {
        ServiceProvider newServiceProvider = this.createServiceProvider("* New ServiceProvider *");
        if (newServiceProvider == null) {
            throw new Exception("ServiceProvider: * New ServiceProvider * already defined");
        }
        return newServiceProvider;
    }

    public ServiceProvider createServiceProvider(String aName) {
        if (this.m_providerList.containsKey(aName)) {
            return null;
        }
        ServiceProvider owner = new ServiceProvider(aName);
        this.m_providerList.put(aName, owner);
        return owner;
    }

    public int addServiceProvider(ServiceProvider aServiceProvider) {
        Debug.debug(4, "RatingManager:addServiceProvider()");
        if (this.m_providerList.containsKey(aServiceProvider.getName())) {
            return 1;
        }
        Debug.debug("RatingManager -- Add ServiceProvider: " + aServiceProvider.getName());
        this.m_providerList.put(aServiceProvider.getName(), aServiceProvider);
        Debug.debug("RatingManager -- No of ServiceProviders [ " + this.m_providerList.size() + " ]");
        return 0;
    }

    public ServiceProvider getServiceProvider(String aName) {
        Debug.debug(4, "RatingManager:getServiceProvider()");
        return this.m_providerList.get(aName);
    }

    public Collection<ServiceProvider> getAllServiceProviders() {
        return Collections.unmodifiableCollection(this.m_providerList.values());
    }

    public ServiceProvider removeServiceProvider(String aName) {
        Debug.debug("RatingManager:removeServiceProvider( " + aName + " )");
        ServiceProvider aServiceProvider = this.m_providerList.get(aName);
        if (aServiceProvider != null) {
            if (aServiceProvider.containsRatingPlans()) {
                aServiceProvider.removeAllRatingPlans();
            }
            return this.m_providerList.remove(aName);
        }
        Debug.debug("RatingManager:removeServiceProvider -- No of ServiceProviders [ " + this.m_providerList.size() + " ]");
        return null;
    }

    public void printAll() {
        System.out.println("Rating Manager Name is " + this.m_name);
        for (Service service : this.m_services.values()) {
            System.out.println(service.toString());
        }
        for (ServiceProvider serviceProvider : this.m_providerList.values()) {
            serviceProvider.printAll();
        }
    }

    public Service[] getServiceStringArr() {
        return this.m_services.values().toArray(new Service[this.m_services.size()]);
    }

    public String getStartTag(String tabs) {
        return tabs + "<" + TAG_NAME + this.createAttribute("Name", this.m_name) + " >";
    }

    public String getEndTag(String tabs) {
        return tabs + "</" + TAG_NAME + ">";
    }

    private String createAttribute(String name, String value) {
        return " " + name + "=" + '\"' + value + '\"' + " ";
    }

    public String getXMLDefinition() {
        StringBuffer buf = this.getProperties();
        buf.deleteCharAt(0);
        return buf.toString();
    }

    public StringBuffer getProperties() {
        StringBuffer buf = new StringBuffer("\n");
        String tabs = "";
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\n");
        buf.append(this.getStartTag("") + "\n");
        tabs = "\t";
        buf.append(tabs + "<ServiceList>\n");
        for (Service currentService : this.m_services.values()) {
            buf.append(currentService.getXMLDefinition(tabs));
        }
        buf.append(tabs + "</ServiceList>\n");
        for (ServiceProvider currentServiceProvider : this.m_providerList.values()) {
            buf.append(currentServiceProvider.getXMLDefinition(tabs));
        }
        buf.append(this.getEndTag(""));
        return buf;
    }
}

