/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import ericsson.ere.management.ContextKey;
import ericsson.ere.util.StringUtil;

public final class FieldContext {
    private final String myServiceProviderName;
    private final String myRatingPlanName;
    private static final ContextKey INVALID_KEY = new ContextKey(null);
    static final FieldContext NO_CONTEXT = new FieldContext();

    private FieldContext() {
        this.myServiceProviderName = "";
        this.myRatingPlanName = "";
    }

    public FieldContext(String serviceProvider) {
        if (StringUtil.isEmptyString(serviceProvider)) {
            throw new IllegalArgumentException("Service provider name may NOT be null or empty string");
        }
        this.myServiceProviderName = serviceProvider;
        this.myRatingPlanName = "";
    }

    public boolean isServiceProviderField() {
        return "".equals(this.myRatingPlanName);
    }

    public boolean isRatingPlanField() {
        return !"".equals(this.myRatingPlanName);
    }

    public FieldContext(String serviceProvider, String ratingPlan) {
        if (StringUtil.isEmptyString(serviceProvider) || StringUtil.isEmptyString(ratingPlan)) {
            throw new IllegalArgumentException("Neither Service provider name or Rating plan name may NOT be null or empty string");
        }
        this.myServiceProviderName = serviceProvider;
        this.myRatingPlanName = ratingPlan;
    }

    public ContextKey getServiceProviderContextKey() {
        return new ContextKey(this.myServiceProviderName);
    }

    public ContextKey getRatingPlanContextKey() {
        if (this.myRatingPlanName == null) {
            return INVALID_KEY;
        }
        return new ContextKey(this.myServiceProviderName, this.myRatingPlanName);
    }

    public String getServiceProviderStringKey() {
        return this.myServiceProviderName;
    }

    public String getRatingPlanStringKey() {
        return this.myRatingPlanName + "@" + this.myServiceProviderName;
    }

    public String getServiceProviderName() {
        return this.myServiceProviderName;
    }

    public String getRatingPlanName() {
        return this.myRatingPlanName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myRatingPlanName == null ? 0 : this.myRatingPlanName.hashCode());
        result = 31 * result + (this.myServiceProviderName == null ? 0 : this.myServiceProviderName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldContext other = (FieldContext)obj;
        if (this.myRatingPlanName == null ? other.myRatingPlanName != null : !this.myRatingPlanName.equals(other.myRatingPlanName)) {
            return false;
        }
        return !(this.myServiceProviderName == null ? other.myServiceProviderName != null : !this.myServiceProviderName.equals(other.myServiceProviderName));
    }
}

