/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import ericsson.ere.defs.EreDefs;
import ericsson.ere.exception.RatingException;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class RatingPlan {
    private String TAG_NAME = "RatingPlan";
    private String m_name;
    private String m_identity;
    private String m_serviceId;
    private ServiceProvider m_provider;
    private Service m_service;
    private List<RatingPeriod> m_ratingPeriods = new ArrayList<RatingPeriod>();

    public RatingPlan(ServiceProvider aProvider, String aName, String anIdentity, String aServiceId) {
        this(aProvider, anIdentity, aName);
        this.m_serviceId = aServiceId;
    }

    protected RatingPlan(ServiceProvider aProvider, String anIdentity, String aName) {
        this.m_provider = aProvider;
        this.m_name = aName.trim();
        this.m_identity = anIdentity;
    }

    public int setOneRatingPeriod(RatingPeriod aPeriod) {
        if (this.m_ratingPeriods.size() == 0) {
            this.m_ratingPeriods.add(aPeriod);
        } else {
            this.m_ratingPeriods.set(0, aPeriod);
            if (this.m_ratingPeriods.size() > 1) {
                for (int ii = this.m_ratingPeriods.size(); ii > 1; --ii) {
                    try {
                        this.m_ratingPeriods.remove(1);
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        if (this.m_ratingPeriods.size() != 0) continue;
                        return 4;
                    }
                }
            }
        }
        return 0;
    }

    public int addRatingPeriod(RatingPeriod aPeriod) {
        for (int i = 0; i < this.m_ratingPeriods.size(); ++i) {
            RatingPeriod period = this.m_ratingPeriods.get(i);
            if (RatingPlan.areTimesEqualBySecond(period.getStartTime(), aPeriod.getStartTime())) {
                return 1;
            }
            if (!RatingPlan.isTimeBeforeBySecond(aPeriod.getStartTime(), period.getStartTime())) continue;
            this.m_ratingPeriods.add(i, aPeriod);
            return 0;
        }
        this.m_ratingPeriods.add(aPeriod);
        return 0;
    }

    public final RatingPeriod getRatingPeriod(String aName, String startDateAndTime) {
        return this.getRatingPeriod(aName, DateUtil.parse(startDateAndTime));
    }

    public final RatingPeriod getRatingPeriod(String aName, Calendar startDateAndTime) {
        for (RatingPeriod period : this.m_ratingPeriods) {
            if (!period.equals(aName, startDateAndTime)) continue;
            return period;
        }
        return null;
    }

    public final RatingPeriod getActualRatingPeriod(Calendar startTime) throws RatingException {
        if (startTime == null) {
            if (this.m_ratingPeriods.size() > 0) {
                return this.m_ratingPeriods.get(0);
            }
            throw new RatingException(7, EreDefs.getErrorString("error.noValidPeriod") + "null start time");
        }
        RatingPeriod period = null;
        for (int ii = this.m_ratingPeriods.size() - 1; ii >= 0; --ii) {
            period = this.m_ratingPeriods.get(ii);
            if (!RatingPlan.isTimeAfterOrEqualsBySecond(startTime, period.getStartTime())) continue;
            return period;
        }
        throw new RatingException(7, EreDefs.getErrorString("error.noValidPeriod") + "start time " + DateUtil.formatISODateTime(startTime, false));
    }

    public final boolean hasRatingPeriod(Calendar startTime) {
        if (startTime == null) {
            return this.containsRatingPeriods();
        }
        if (this.m_ratingPeriods.isEmpty()) {
            return false;
        }
        RatingPeriod period = this.m_ratingPeriods.get(0);
        return RatingPlan.isTimeAfterOrEqualsBySecond(startTime, period.getStartTime());
    }

    public final RatingPeriod removeRatingPeriod(String aName, Calendar startDateAndTime) {
        Iterator<RatingPeriod> periodList = this.m_ratingPeriods.iterator();
        while (periodList.hasNext()) {
            RatingPeriod period = periodList.next();
            if (!period.equals(aName, startDateAndTime)) continue;
            periodList.remove();
            return period;
        }
        return null;
    }

    public final List<RatingPeriod> getAllRatingPeriods() {
        return this.m_ratingPeriods;
    }

    public final void removeAllRatingPeriods() {
        this.m_ratingPeriods.clear();
    }

    public final void removeRatingPeriods(List<?> aList, List<RatingPeriod> removed) {
        Iterator<RatingPeriod> currentPeriodsIterator = this.m_ratingPeriods.iterator();
        while (currentPeriodsIterator.hasNext()) {
            RatingPeriod period = currentPeriodsIterator.next();
            if (aList.contains(period)) continue;
            currentPeriodsIterator.remove();
            removed.add(period);
        }
    }

    public final boolean containsRatingPeriods() {
        return !this.m_ratingPeriods.isEmpty();
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String aName) {
        this.m_name = aName.trim();
    }

    public String getIdentity() {
        return this.m_identity;
    }

    public String getServiceName() {
        return this.m_serviceId;
    }

    public Service getService() {
        return this.m_service;
    }

    public void setService(Service aService) {
        this.m_service = aService;
        this.m_serviceId = aService.getId();
    }

    @Deprecated
    public ServiceProvider getServiceProviderName() {
        return this.m_provider;
    }

    public ServiceProvider getServiceProvider() {
        return this.m_provider;
    }

    public String getNameOfServiceProvider() {
        return this.m_provider.getName();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        RatingPlan aPlan = (RatingPlan)anObject;
        return this.m_identity.equals(aPlan.m_identity) && this.m_serviceId.equals(aPlan.m_serviceId) && this.m_provider.equals(aPlan.m_provider);
    }

    public void printAll() {
        System.out.println(this.toString());
        for (RatingPeriod period : this.m_ratingPeriods) {
            period.printAll();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Rating Plan Name: ").append(this.m_name).append("\n");
        buffer.append("Rating Plan Identity: ").append(this.m_identity).append("\n");
        buffer.append("Service Name: ").append(this.m_serviceId).append("\n");
        return buffer.toString();
    }

    @Deprecated
    public RatingPeriod createRatingPeriod() {
        RatingPeriod ratingPeriod = new RatingPeriod(this, "* New RatingPeriod*", this.m_provider.getName());
        this.m_ratingPeriods.add(ratingPeriod);
        return ratingPeriod;
    }

    public void changeRatingPlanName(String identity) throws Exception {
        String newIdentity = identity.trim();
        if (!newIdentity.equals(this.m_identity)) {
            if (this.m_provider.getRatingPlan(newIdentity) != null) {
                throw new Exception(EreDefs.getErrorString("error.planAlreadyExists") + identity);
            }
            this.m_provider.removeRatingPlan(this.m_identity);
            this.m_name = newIdentity + "%" + this.m_provider.getName();
            this.m_identity = newIdentity;
            this.m_provider.addRatingPlan(this);
        }
    }

    public void setService(String aServiceName, EreManager ereManager) {
        this.m_serviceId = aServiceName;
        this.m_service = ereManager.getService(this.m_serviceId);
    }

    public String getXMLDefinition(String tabs) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getStartTag(tabs) + "\n");
        for (RatingPeriod currentRatingPeriod : this.m_ratingPeriods) {
            buf.append(currentRatingPeriod.getXMLDefinition(tabs + "\t"));
        }
        buf.append(this.getEndTag(tabs) + "\n");
        return buf.toString();
    }

    public String getStartTag(String tabs) {
        return tabs + "<" + this.TAG_NAME + XMLUtil.wrapInAttribute("Name", this.m_identity) + XMLUtil.wrapInAttribute("Service", this.m_serviceId) + " >";
    }

    public String getEndTag(String tabs) {
        return tabs + "</" + this.TAG_NAME + ">";
    }

    public synchronized int replacePeriodByStartTime(RatingPeriod rpNew) {
        if (!this.getIdentity().equals(rpNew.getRatingPlanId())) {
            throw new IllegalArgumentException("Rating plan ID mismatch, got " + rpNew.getRatingPlanId() + " but this plan has " + this.getIdentity());
        }
        int len = this.m_ratingPeriods.size();
        boolean replaced = false;
        for (int i = 0; !replaced && i < len; ++i) {
            if (!RatingPlan.areTimesEqualBySecond(this.m_ratingPeriods.get(i).getStartTime(), rpNew.getStartTime())) continue;
            this.m_ratingPeriods.set(i, rpNew);
            replaced = true;
        }
        return replaced ? 0 : 2;
    }

    static boolean areTimesEqualBySecond(Calendar cal1, Calendar cal2) {
        return RatingPlan.isTimeAfterOrEqualsBySecond(cal1, cal2) && RatingPlan.isTimeAfterOrEqualsBySecond(cal2, cal1);
    }

    static boolean isTimeBeforeBySecond(Calendar cal, Calendar reference) {
        return !RatingPlan.isTimeAfterOrEqualsBySecond(cal, reference);
    }

    static boolean isTimeAfterOrEqualsBySecond(Calendar cal, Calendar reference) {
        if (cal.get(1) < reference.get(1)) {
            return false;
        }
        if (cal.get(1) > reference.get(1)) {
            return true;
        }
        if (cal.get(2) < reference.get(2)) {
            return false;
        }
        if (cal.get(2) > reference.get(2)) {
            return true;
        }
        if (cal.get(5) < reference.get(5)) {
            return false;
        }
        if (cal.get(5) > reference.get(5)) {
            return true;
        }
        if (cal.get(11) < reference.get(11)) {
            return false;
        }
        if (cal.get(11) > reference.get(11)) {
            return true;
        }
        if (cal.get(12) < reference.get(12)) {
            return false;
        }
        if (cal.get(12) > reference.get(12)) {
            return true;
        }
        return cal.get(13) >= reference.get(13);
    }

    public FieldContext getFieldContext() {
        String serviceProviderId = this.getNameOfServiceProvider();
        String ratingPlanId = this.getIdentity();
        if (!StringUtil.isEmptyString(serviceProviderId) || !StringUtil.isEmptyString(ratingPlanId)) {
            return new FieldContext(serviceProviderId, ratingPlanId);
        }
        return null;
    }
}

