/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import ericsson.ere.defs.EreDefs;
import ericsson.ere.management.Debug;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServiceProvider {
    private String TAG_NAME = "ServiceProvider";
    @Deprecated
    public String m_name;
    @Deprecated
    public Map<String, RatingPlan> m_ratingPlans;

    public ServiceProvider(String name) {
        this.m_name = name.trim();
        this.m_ratingPlans = new HashMap<String, RatingPlan>();
    }

    public int addRatingPlan(RatingPlan aPlan) {
        Debug.debug(3, "ServiceProvider:addRatingPlan()");
        if (this.m_ratingPlans.containsKey(aPlan.getIdentity())) {
            return 1;
        }
        this.m_ratingPlans.put(aPlan.getIdentity(), aPlan);
        Debug.debug("ServiceProvider -- No of Rating Plans [ " + this.m_ratingPlans.size() + " ]");
        return 0;
    }

    public RatingPlan getRatingPlan(String anIdentity) {
        Debug.debug(4, "ServiceProvider:getRatingPlan()");
        return this.m_ratingPlans.get(anIdentity);
    }

    public RatingPlan getRatingPlanByName(String aName) {
        Debug.debug(4, "ServiceProvider:getRatingPlanByName()");
        for (RatingPlan theRatingPlan : this.m_ratingPlans.values()) {
            if (!theRatingPlan.getName().equals(aName)) continue;
            return theRatingPlan;
        }
        return null;
    }

    @Deprecated
    public Collection<RatingPlan> getAllRatingPlans() {
        return this.m_ratingPlans.values();
    }

    public final Collection<RatingPlan> getRatingPlans() {
        return Collections.unmodifiableCollection(this.m_ratingPlans.values());
    }

    public boolean containsRatingPlan(String anIdentity) {
        return this.m_ratingPlans.containsKey(anIdentity);
    }

    public RatingPlan removeRatingPlan(String anIdentity) {
        Debug.debug(3, "ServiceProvider:removeRatingPlan(" + anIdentity + ")");
        return this.m_ratingPlans.remove(anIdentity);
    }

    public void removeAllRatingPlans() {
        if (this.m_ratingPlans.isEmpty()) {
            return;
        }
        for (RatingPlan plan : this.m_ratingPlans.values()) {
            plan.removeAllRatingPeriods();
        }
        this.m_ratingPlans.clear();
    }

    public boolean containsRatingPlans() {
        return !this.m_ratingPlans.isEmpty();
    }

    public void removeRatingPeriods(List<?> aList, List<RatingPeriod> removed) {
        Debug.debug(4, "ServiceProvider:removeRatingPeriods()");
        Iterator<RatingPlan> planIterator = this.m_ratingPlans.values().iterator();
        while (planIterator.hasNext()) {
            RatingPlan plan = planIterator.next();
            plan.removeRatingPeriods(aList, removed);
            if (plan.containsRatingPeriods()) continue;
            Debug.debug(3, "ServiceProvider:removeRatingPeriods() -- No Rating Periods left, remove plan");
            planIterator.remove();
            Debug.debug(3, "ServiceProvider:removeRatingPeriods() -- No of Rating Plans [ " + this.m_ratingPlans.size() + " ]");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public boolean equals(Object anObject) {
        Debug.debug(3, "ServiceProvider:equals()");
        if (anObject == null || anObject.getClass() != this.getClass()) {
            return false;
        }
        if (anObject == this) {
            return true;
        }
        ServiceProvider aServiceProvider = (ServiceProvider)anObject;
        return this.m_name.equals(aServiceProvider.getName());
    }

    public String toString() {
        return "Service Provider: " + this.m_name;
    }

    public void printAll() {
        System.out.println(this + "\n");
        for (RatingPlan plan : this.m_ratingPlans.values()) {
            plan.printAll();
        }
    }

    public void changeServiceProviderName(String newName, EreManager ereManager) throws Exception {
        String newNameT = newName.trim();
        if (!newNameT.equals(this.m_name)) {
            if (ereManager.getServiceProvider(newNameT) != null) {
                throw new Exception(EreDefs.getErrorString("error.providerAlreadyExists") + newName);
            }
            ereManager.removeServiceProvider(this.m_name);
            this.m_name = newNameT;
            ereManager.addServiceProvider(this);
        }
    }

    public RatingPlan createRatingPlan(String serviceId) throws Exception {
        String ratingPlanId = "* New RatingPlanIdentity *";
        String ratingPlanName = ratingPlanId + "%" + this.m_name;
        if (this.m_ratingPlans.containsKey(ratingPlanId)) {
            throw new Exception(EreDefs.getErrorString("error.planAlreadyExists") + ratingPlanId);
        }
        RatingPlan ratingPlan = new RatingPlan(this, ratingPlanName, ratingPlanId, serviceId);
        this.m_ratingPlans.put(ratingPlanId, ratingPlan);
        return ratingPlan;
    }

    public String getXMLDefinition(String tabs) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getStartTag(tabs) + "\n");
        for (RatingPlan currentRatingPlan : this.m_ratingPlans.values()) {
            buf.append(currentRatingPlan.getXMLDefinition(tabs + "\t"));
        }
        buf.append(this.getEndTag(tabs) + "\n");
        return buf.toString();
    }

    public String getStartTag(String tabs) {
        return tabs + "<" + this.TAG_NAME + this.createAttribute("Name", this.m_name) + " >";
    }

    public String getEndTag(String tabs) {
        return tabs + "</" + this.TAG_NAME + ">";
    }

    private String createAttribute(String name, String value) {
        return " " + name + "=" + '\"' + value + '\"' + " ";
    }
}

