/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.xml;

import java.util.HashMap;
import java.util.Map;

public class Entities {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}, {"apos", "39"}};
    public static final Entities XML = new Entities();
    EntityMap map = new LookupEntityMap();

    public void addEntities(String[][] entityArray) {
        for (int i = 0; i < entityArray.length; ++i) {
            this.addEntity(entityArray[i][0], Integer.parseInt(entityArray[i][1]));
        }
    }

    public void addEntity(String name, int value) {
        this.map.add(name, value);
    }

    public int entityValue(String name) {
        return this.map.value(name);
    }

    public String unescape(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                char charAt1;
                int semi = str.indexOf(59, i + 1);
                if (semi == -1) {
                    buf.append(ch);
                    continue;
                }
                String entityName = str.substring(i + 1, semi);
                int entityValue = entityName.charAt(0) == '#' ? ((charAt1 = entityName.charAt(1)) == 'x' || charAt1 == 'X' ? Integer.valueOf(entityName.substring(2), 16) : Integer.parseInt(entityName.substring(1))) : this.entityValue(entityName);
                if (entityValue == -1) {
                    buf.append('&');
                    buf.append(entityName);
                    buf.append(';');
                } else {
                    buf.append((char)entityValue);
                }
                i = semi;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    static {
        XML.addEntities(BASIC_ARRAY);
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        @Override
        public String name(int value) {
            if (value < this.LOOKUP_TABLE_SIZE) {
                return this.lookupTable()[value];
            }
            return super.name(value);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[this.LOOKUP_TABLE_SIZE];
            for (int i = 0; i < this.LOOKUP_TABLE_SIZE; ++i) {
                this.lookupTable[i] = super.name(i);
            }
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private Map<String, Integer> mapNameToValue = new HashMap<String, Integer>();
        private HashMap<Integer, String> mapValueToName = new HashMap();

        PrimitiveEntityMap() {
        }

        @Override
        public void add(String name, int value) {
            this.mapNameToValue.put(name, new Integer(value));
            this.mapValueToName.put(value, name);
        }

        @Override
        public String name(int value) {
            return this.mapValueToName.get(value);
        }

        @Override
        public int value(String name) {
            Integer value = this.mapNameToValue.get(name);
            if (value == null) {
                return -1;
            }
            return value;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

