/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.xml;

import ericsson.ere.exception.EreException;
import ericsson.ere.exception.EreFileException;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.Entities;
import ericsson.ere.xml.EreXmlErrorHandler;
import ericsson.ere.xml.ValidatingEntityHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLUtil {
    private static DocumentBuilderFactory myDocFactory = null;
    public static final char[] ENTITY_CHARS = new char[]{'&', '<', '>', '\"', '\''};
    public static final String[] ENTITY_REF = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};
    private static DocumentBuilder myBuilder;

    private XMLUtil() {
    }

    public static String escape(String src) {
        String ret = src;
        boolean mustReplace = false;
        for (int i = 0; i < ENTITY_CHARS.length; ++i) {
            int pos = ret.indexOf(ENTITY_CHARS[i]);
            if (pos < 0) continue;
            mustReplace = true;
            break;
        }
        if (mustReplace) {
            StringBuffer buf = new StringBuffer(src);
            for (int i = 0; i < ENTITY_CHARS.length; ++i) {
                int pos;
                for (pos = 0; pos < buf.length() && ENTITY_CHARS[i] != buf.charAt(pos); ++pos) {
                }
                while (pos < buf.length()) {
                    buf.replace(pos, pos + 1, ENTITY_REF[i]);
                    pos += ENTITY_REF[i].length();
                    while (pos < buf.length() && ENTITY_CHARS[i] != buf.charAt(pos)) {
                        ++pos;
                    }
                }
            }
            ret = buf.toString();
        }
        return ret;
    }

    public static String unEscape(String src) {
        return Entities.XML.unescape(src);
    }

    public static Document documentFromFile(File file) throws Exception {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EreFileException(file.getPath(), "ParserConfigurationException :" + e.getMessage(), e);
        }
        builder.setEntityResolver(new DefaultHandler());
        try {
            Document document = builder.parse(file);
            return document;
        }
        catch (SAXException e) {
            throw new EreFileException(file.getPath(), "SAXException :" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EreFileException(file.getPath(), "IOException :" + e.getMessage(), e);
        }
    }

    public static Document documentFromFile(String fileName) throws Exception {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EreFileException(fileName, "ParserConfigurationException :" + e.getMessage(), e);
        }
        builder.setEntityResolver(new DefaultHandler());
        try {
            Document document = builder.parse(new File(fileName));
            return document;
        }
        catch (SAXException e) {
            throw new EreFileException(fileName, "SAXException :" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EreFileException(fileName, "IOException :" + e.getMessage(), e);
        }
    }

    public static Document documentFromString(String xmlCode) throws Exception {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EreException("ParserConfigurationException :" + e.getMessage(), e);
        }
        builder.setEntityResolver(new DefaultHandler());
        try {
            Document document = builder.parse(new InputSource(new StringReader(xmlCode)));
            return document;
        }
        catch (SAXException e) {
            throw new EreException("SAXException :" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EreException("IOException :" + e.getMessage(), e);
        }
    }

    public static Document buildDocumentFromFile(File file) throws ParserConfigurationException, IOException, SAXException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        try (FileInputStream stream = new FileInputStream(file);){
            Document document = XMLUtil.buildDocument(new InputSource(stream));
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildDocumentFromFileAndValidate(File file) throws Exception {
        XMLUtil.ensureDocumentFactory();
        boolean oldIsValidating = myDocFactory.isValidating();
        if (!oldIsValidating) {
            myDocFactory.setValidating(true);
        }
        try {
            Document document;
            DocumentBuilder builder = myDocFactory.newDocumentBuilder();
            builder.setEntityResolver(new DefaultHandler());
            FileInputStream stream = new FileInputStream(file);
            try {
                document = builder.parse(stream);
            }
            catch (Throwable throwable) {
                ((InputStream)stream).close();
                throw throwable;
            }
            ((InputStream)stream).close();
            return document;
        }
        finally {
            if (!oldIsValidating) {
                myDocFactory.setValidating(false);
            }
        }
    }

    public static Document buildDocumentWithProvidedDTD(File file, InputSource dtdSource, String dtdName) throws IOException, SAXException {
        XMLUtil.ensureDocumentFactory();
        boolean oldIsValidating = myDocFactory.isValidating();
        if (!oldIsValidating) {
            myDocFactory.setValidating(true);
        }
        try {
            DocumentBuilder builder = myDocFactory.newDocumentBuilder();
            builder.setErrorHandler(new EreXmlErrorHandler());
            builder.setEntityResolver(new ValidatingEntityHandler(dtdSource, dtdName));
            Document document = builder.parse(file);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new AssertionError((Object)("Faulty configuration for DocumentBuilder " + ex.getMessage()));
        }
        finally {
            if (!oldIsValidating) {
                myDocFactory.setValidating(false);
            }
        }
    }

    public static Document buildDocumentFromString(String s) throws Exception {
        return XMLUtil.buildDocument(new StringReader(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildDocumentFromStringAndValidate(String s) throws Exception {
        XMLUtil.ensureDocumentFactory();
        boolean oldIsValidating = myDocFactory.isValidating();
        if (!oldIsValidating) {
            myDocFactory.setValidating(true);
            myDocFactory.setNamespaceAware(true);
        }
        try {
            Document d;
            DocumentBuilder builder = myDocFactory.newDocumentBuilder();
            builder.setEntityResolver(new DefaultHandler());
            builder.setErrorHandler(new EreXmlErrorHandler());
            Document document = d = builder.parse(new InputSource(new StringReader(s)));
            return document;
        }
        finally {
            if (!oldIsValidating) {
                myDocFactory.setValidating(false);
                myDocFactory.setNamespaceAware(false);
            }
        }
    }

    public static Document buildDocument(Reader in) throws Exception {
        return XMLUtil.buildDocument(new InputSource(in));
    }

    public static Document buildDocument(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        return XMLUtil.buildDocument(new InputSource(in));
    }

    private static Document buildDocument(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        XMLUtil.ensureDocumentFactory();
        DocumentBuilder builder = myDocFactory.newDocumentBuilder();
        builder.setEntityResolver(new DefaultHandler());
        return builder.parse(source);
    }

    public static int countNamedElements(String name, NodeList list) {
        int retVal = 0;
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !name.equalsIgnoreCase(node.getNodeName())) continue;
            ++retVal;
        }
        return retVal;
    }

    public static Element getNamedElement(String name, NodeList list) {
        Object retVal = null;
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !name.equalsIgnoreCase(node.getNodeName())) continue;
            return (Element)node;
        }
        return retVal;
    }

    public static Node getElementWithNameAndAttribute(String name, String attrName, String attrValue, NodeList list) {
        List<Element> elements = XMLUtil.getElementNodesNamed(name, list);
        for (Element e : elements) {
            if (!e.hasAttributes()) continue;
            NamedNodeMap attrs = e.getAttributes();
            int nattr = attrs.getLength();
            for (int a = 0; a < nattr; ++a) {
                Node attr = attrs.item(a);
                if (!attrName.equalsIgnoreCase(attr.getNodeName()) || !attrValue.equalsIgnoreCase(attr.getNodeValue())) continue;
                return e;
            }
        }
        return null;
    }

    public static List<Element> getElementNodesNamed(String name, NodeList list) {
        int len = list.getLength();
        ArrayList<Element> l = new ArrayList<Element>(len);
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !name.equalsIgnoreCase(node.getNodeName())) continue;
            l.add((Element)node);
        }
        return l;
    }

    public static String getFirstTextContent(Node node) {
        if (node == null) {
            throw new NullPointerException("Node input is null.");
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue().trim();
        }
        return "";
    }

    public static String getPathname(Node node) {
        StringBuffer buf = XMLUtil.readPathname(node, new StringBuffer());
        return buf.toString();
    }

    private static StringBuffer readPathname(Node node, StringBuffer buf) {
        Node parent;
        if (node.getNodeType() == 1) {
            String text = XMLUtil.getFirstTextContent(node);
            if (text == null) {
                text = "'null'";
            }
            if (buf.length() > 0) {
                buf.insert(0, "/");
            }
            buf.insert(0, text);
        }
        if ((parent = node.getParentNode()) != null) {
            XMLUtil.readPathname(parent, buf);
        }
        return buf;
    }

    @Deprecated
    public static String getStringRepresentation(Node node) {
        StringBuffer buf = XMLUtil.getStringRepresentation(node, new StringBuffer(), 0);
        return buf.toString();
    }

    private static StringBuffer getStringRepresentation(Node node, StringBuffer buf, int level) {
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            indent.append("  ");
        }
        switch (node.getNodeType()) {
            case 1: {
                int i;
                int len;
                buf.append(indent);
                buf.append("<");
                buf.append(node.getNodeName());
                int n = len = node.hasAttributes() ? node.getAttributes().getLength() : 0;
                if (len > 0) {
                    buf.append(" ");
                }
                for (i = 0; i < len; ++i) {
                    buf.append(node.getAttributes().item(i).getNodeName());
                    buf.append("=\"");
                    buf.append(XMLUtil.escape(node.getAttributes().item(i).getNodeValue()));
                    buf.append("\" ");
                }
                buf.append(">");
                NodeList children = node.getChildNodes();
                len = children.getLength();
                if (len != 0) {
                    if (len == 1 && children.item(0).getNodeType() == 3) {
                        buf.append(children.item(0).getNodeValue().trim());
                    } else {
                        buf.append("\n");
                        for (i = 0; i < len; ++i) {
                            XMLUtil.getStringRepresentation(children.item(i), buf, level + 1);
                        }
                        buf.append(indent);
                    }
                }
                buf.append("</");
                buf.append(node.getNodeName());
                buf.append(">\n");
                break;
            }
            case 3: {
                String val = node.getNodeValue();
                if (val == null || "".equals(val.trim())) {
                    return buf;
                }
                buf.append(indent);
                buf.append(val.trim());
                buf.append("\n");
                NodeList children = node.getChildNodes();
                int len2 = children.getLength();
                for (int i = 0; i < len2; ++i) {
                    XMLUtil.getStringRepresentation(children.item(i), buf, level + 1);
                }
                break;
            }
            case 9: {
                for (Node child : new NodeListIterable(node.getChildNodes())) {
                    XMLUtil.getStringRepresentation(child, buf, level + 1);
                }
                break;
            }
            default: {
                Logger.getLogger("XMLUtil").log(Level.WARNING, "Unhandled DOM Node type: " + node.getNodeType());
            }
        }
        return buf;
    }

    public static Element getFirstElementNamed(String name, Element parent) {
        Element result = null;
        try {
            NodeList tList = parent.getElementsByTagName(name);
            result = (Element)tList.item(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean containsElementNamed(Element rootElement, String elementTagName) {
        NodeList nodeList = rootElement.getElementsByTagName(elementTagName);
        return nodeList.getLength() != 0;
    }

    public static String getAttributeFromElement(Element fromElement, String attributeName, String defaultValue) {
        String result = fromElement.getAttribute(attributeName);
        if (result.length() == 0) {
            result = defaultValue;
        }
        return result;
    }

    public static String getAttributeValue(NamedNodeMap attributes, String attributeName, String defaultValue) {
        Node attr;
        String result = defaultValue;
        if (attributes != null && (attr = attributes.getNamedItem(attributeName)) != null) {
            result = attr.getNodeValue();
        }
        return result;
    }

    public static Document createEmptyDocument() {
        XMLUtil.ensureDocumentFactory();
        return myBuilder.newDocument();
    }

    private static void ensureDocumentFactory() {
        if (myDocFactory == null) {
            myDocFactory = DocumentBuilderFactory.newInstance();
            try {
                myBuilder = myDocFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new AssertionError((Object)e);
            }
        }
        myBuilder.reset();
    }

    public static Document getEmptyDocument() throws ParserConfigurationException {
        return XMLUtil.createEmptyDocument();
    }

    public static void escapeCharactersInNodeList(NodeList list) {
        if (list != null) {
            for (int j = 0; j < list.getLength(); ++j) {
                Node node = list.item(j);
                Node nodeChild = node.getFirstChild();
                if (nodeChild == null) continue;
                String esc = XMLUtil.escape(nodeChild.getNodeValue());
                nodeChild.setNodeValue(esc);
            }
        }
    }

    public static List<Node> getElementChildren(Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Node> elementChildren = new ArrayList<Node>(children.getLength());
        for (Node n : new NodeListIterable(children, 1)) {
            elementChildren.add(n);
        }
        return elementChildren;
    }

    public static List<Element> getElementChildList(Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Element> elementChildren = new ArrayList<Element>(children.getLength());
        for (Node n : new NodeListIterable(children, 1)) {
            elementChildren.add((Element)n);
        }
        return elementChildren;
    }

    public static String wrapInTag(String tag, String value) {
        String xml = value == null ? null : XMLUtil.escape(value);
        return XMLUtil.wrapXMLInTag(tag, xml);
    }

    public static String wrapXMLInTag(String tag, String xml) {
        if (tag == null) {
            throw new IllegalArgumentException("Null tag name not permitted.");
        }
        if (xml == null || xml.length() == 0) {
            return String.format("<%s/>", tag);
        }
        return String.format("<%1$s>%2$s</%1$s>", tag, xml);
    }

    public static String wrapInAttribute(String attribute, Object value) {
        return XMLUtil.wrapInAttribute(attribute, String.valueOf(value));
    }

    public static String wrapInAttribute(String attribute, String value) {
        if (attribute == null) {
            throw new IllegalArgumentException("Null attribute name not permitted.");
        }
        if (value == null || value.length() == 0) {
            return "";
        }
        return String.format(" %s=\"%s\"", attribute, XMLUtil.escape(value));
    }

    public static String wrapValueOrEmptyStringInAttribute(String attribute, String value) {
        String result = XMLUtil.wrapInAttribute(attribute, value);
        if (result.equals("")) {
            result = String.format(" %s=\"\"", attribute);
        }
        return result;
    }

    public static void printDOMNode(Node node, PrintWriter out, int indentLevel, String indentMarker) {
        switch (node.getNodeType()) {
            case 1: {
                boolean isLastText;
                int len;
                if (indentMarker.length() > 0) {
                    for (int i = 0; i < indentLevel; ++i) {
                        out.print(indentMarker);
                    }
                }
                NamedNodeMap attrs = null;
                if (node.hasAttributes()) {
                    attrs = node.getAttributes();
                }
                NodeList children = node.getChildNodes();
                out.print("<");
                out.print(node.getNodeName());
                if (attrs != null) {
                    len = attrs.getLength();
                    for (int i = 0; i < len; ++i) {
                        Node attr = attrs.item(i);
                        out.print(" ");
                        out.print(attr.getNodeName());
                        out.print("=\"");
                        out.print(XMLUtil.escape(attr.getNodeValue()));
                        out.print("\"");
                    }
                }
                if ((len = children.getLength()) == 0) {
                    out.println("/>");
                    break;
                }
                out.print(">");
                Node firstChild = children.item(0);
                Node lastChild = children.item(len - 1);
                boolean isFirstText = firstChild.getNodeType() == 3;
                boolean bl = isLastText = lastChild.getNodeType() == 3;
                if (!isFirstText) {
                    out.println();
                }
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    XMLUtil.printDOMNode(child, out, indentLevel + 1, indentMarker);
                    if (i != 0 || len <= 1 || child.getNodeType() != 3) continue;
                    out.println();
                }
                if (!isLastText && indentMarker.length() > 0) {
                    for (int j = 0; j < indentLevel; ++j) {
                        out.print(indentMarker);
                    }
                }
                out.print("</");
                out.print(node.getNodeName());
                out.println(">");
                break;
            }
            case 3: {
                String val = node.getNodeValue();
                if (val == null) {
                    return;
                }
                if ("".equals(val = val.trim())) {
                    return;
                }
                out.print(XMLUtil.escape(val));
                NodeList children = node.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    XMLUtil.printDOMNode(children.item(i), out, indentLevel + 1, indentMarker);
                }
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.print("?>");
                break;
            }
            case 8: {
                out.print("<!--");
                String comment = node.getNodeValue();
                if (comment != null && comment.length() > 0) {
                    out.print(comment);
                }
                out.print("-->");
                break;
            }
            default: {
                System.err.println("Unhandled DOM Node type: " + node.getNodeType());
                NodeList children = node.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    XMLUtil.printDOMNode(children.item(i), out, indentLevel + 1, indentMarker);
                }
            }
        }
    }

    public static String indentXML(String xml, int indentLevel, String indentMarker) {
        StringBuilder builder = new StringBuilder();
        int lineStartIdx = 0;
        int mark = 0;
        do {
            builder.append(xml.substring(mark, lineStartIdx));
            if (XMLUtil.charAtEquals(xml, lineStartIdx, '<') && !XMLUtil.charAtEquals(xml, lineStartIdx + 1, '/')) {
                StringUtil.repeat(indentMarker, indentLevel, builder);
            }
            mark = lineStartIdx;
        } while ((lineStartIdx = xml.indexOf(10, lineStartIdx) + 1) > mark && lineStartIdx < xml.length());
        builder.append(xml.substring(mark));
        return builder.toString();
    }

    private static boolean charAtEquals(String str, int position, char expected) {
        return position < str.length() && expected == str.charAt(position);
    }

    public static Node adoptNode(Document doc, Node node) {
        node.normalize();
        XMLUtil.makeAttributesSpecified(node);
        Node adopted = doc.adoptNode(node);
        return adopted;
    }

    private static void makeAttributesSpecified(Node node) {
        NamedNodeMap attributes;
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            Document ownerDoc = attr.getOwnerDocument();
            Element ownerElement = attr.getOwnerElement();
            if ((attr = (Attr)ownerDoc.adoptNode(attr)) == null) {
                throw new AssertionError((Object)"DOM node to adopt of a different implementation??");
            }
            if (ownerElement != null) {
                ownerElement.setAttributeNode(attr);
            }
        }
        if ((attributes = node.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                XMLUtil.makeAttributesSpecified(attributes.item(i));
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XMLUtil.makeAttributesSpecified(children.item(i));
        }
    }

    public static Element cloneElement(Element element) {
        return (Element)XMLUtil.createEmptyDocument().importNode(element, true);
    }
}

