/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor;

import ericsson.vareditor.VarTableUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class VarTableModel
extends AbstractTableModel
implements Cloneable {
    protected JTable myTable = null;
    private boolean myIsReadOnly = false;
    boolean DEBUG = false;
    private String[] columnNames = new String[]{"Name", "Value"};
    private Class<?>[] columnClasses = new Class[]{String.class, Variable.class};
    public List<Variable> dataVector;

    public VarTableModel() {
        this.dataVector = new ArrayList<Variable>(10);
    }

    public VarTableModel(List<Variable> l) {
        this.dataVector = l;
    }

    public Object clone() {
        VarTableModel vtm = new VarTableModel();
        vtm.myIsReadOnly = this.myIsReadOnly;
        vtm.DEBUG = this.DEBUG;
        vtm.columnNames = Arrays.copyOf(this.columnNames, this.columnNames.length);
        Iterator<Variable> it = this.dataVector.iterator();
        while (it.hasNext()) {
            vtm.dataVector.add((Variable)it.next().clone());
        }
        return vtm;
    }

    public void setTable(JTable atable) {
        this.myTable = atable;
        this.setTable();
    }

    private void setTable() {
        VarTableUtil.configureTableForVariables(this.myTable, 0, 1);
    }

    public void setData(Variable[] data) {
        this.setData(Arrays.asList(data));
    }

    public void setData(List<Variable> l) {
        this.dataVector = l;
        this.fireTableStructureChanged();
        if (this.myTable != null) {
            this.setTable();
        }
    }

    public void setColumNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.dataVector == null) {
            return 0;
        }
        return this.dataVector.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.dataVector == null || row >= this.dataVector.size()) {
            return null;
        }
        Variable v = this.dataVector.get(row);
        if (col == 0) {
            if (v.getFormat() == 999) {
                return "";
            }
            return v.getLabel();
        }
        if (col == 1) {
            return v;
        }
        return null;
    }

    public Variable getVariableForLabel(String label) {
        for (Variable var : this.dataVector) {
            if (!var.getLabel().equals(label)) continue;
            return var;
        }
        return null;
    }

    public Variable getVariableForKey(String key) {
        for (Variable var : this.dataVector) {
            if (!var.getKey().equals(key)) continue;
            return var;
        }
        return null;
    }

    public List<Variable> getData() {
        return this.dataVector;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.columnClasses[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.myIsReadOnly) {
            return false;
        }
        if (col == 1) {
            return this.dataVector.get(row).isAllowEdit();
        }
        return false;
    }

    public void removeRow(int row) {
        if (row <= this.dataVector.size()) {
            this.dataVector.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void insertRowAt(Variable o, int i) {
        this.dataVector.add(i, o);
        this.fireTableRowsInserted(i, i);
    }

    public void addRow(Variable variable) {
        this.dataVector.add(variable);
        this.fireTableRowsInserted(this.dataVector.size() - 1, this.dataVector.size() - 1);
    }

    public void setReadOnly(boolean val) {
        this.myIsReadOnly = val;
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }
}

