/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.math.BigInteger;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AllNumbersDocument
extends PlainDocument
implements FieldValidation {
    private String exp = "";
    private DataType myDataType;
    private boolean isEnabled = true;

    public AllNumbersDocument(DataType dataType) {
        this.myDataType = dataType;
        if (!this.myDataType.isNumeric()) {
            throw new IllegalArgumentException("AllNumbersDocument does not support the data type " + this.myDataType.getTypeIdentifier());
        }
        this.exp = this.myDataType.isIntegerNumeric() ? "-?\\d+" : "-?\\d+|-?\\d+[Ee][+-]?\\d*|-?\\d+.\\d*|-?\\d+.\\d*[Ee][+-]?\\d*";
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (this.myDataType.isUnsignedNumeric()) {
            if (proposedResult.charAt(0) == '-') {
                return;
            }
        } else if (proposedResult.equals("-")) {
            super.insertString(offs, str, a);
            return;
        }
        if (this.matchPattern(proposedResult)) {
            if (this.validateInputOnDataType(proposedResult)) {
                super.insertString(offs, str, a);
                return;
            }
            if (!this.myDataType.isIntegerNumeric() && (proposedResult.substring(proposedResult.length() - 1).equalsIgnoreCase("E") || proposedResult.substring(proposedResult.length() - 2).equalsIgnoreCase("E-") || proposedResult.substring(proposedResult.length() - 2).equalsIgnoreCase("E+"))) {
                super.insertString(offs, str, a);
                return;
            }
        }
        RmaDefs.getInstance().controlledBeep();
        StatusPanel.getInstance().setStatusMsg("Input not allowed.");
    }

    @Override
    public boolean isValid(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return this.matchPattern(value) && this.validateInputOnDataType(value);
    }

    private boolean matchPattern(String value) {
        Pattern pattern = Pattern.compile(this.exp);
        return pattern.matcher(value).matches();
    }

    private boolean validateInputOnDataType(String value) {
        try {
            if (this.myDataType == DataType.UNSIGNEDSHORT || this.myDataType == DataType.UNSIGNEDINT || this.myDataType == DataType.UNSIGNEDLONG) {
                return this.validateUnsigned(value);
            }
            return this.myDataType.parseValue(value) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validateUnsigned(String value) {
        BigInteger aValue = new BigInteger(value);
        if (aValue.compareTo(BigInteger.ZERO) < 0) {
            return false;
        }
        return aValue.compareTo((BigInteger)this.myDataType.getMaximumValue()) <= 0;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

