/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalSignificantNumberDocument
extends PlainDocument
implements FieldValidation {
    int mySignificance = 9;
    double myMin = Double.NEGATIVE_INFINITY;
    double myMax = Double.POSITIVE_INFINITY;
    private boolean isEnabled = true;

    public DecimalSignificantNumberDocument() {
    }

    public DecimalSignificantNumberDocument(double min, double max) {
        this.myMin = min;
        this.myMax = max;
    }

    public void setSignificance(int significance) {
        this.mySignificance = significance;
    }

    public int getSignificance() {
        return this.mySignificance;
    }

    double getMinValue() {
        return this.myMin;
    }

    void setMinValue(double v) {
        this.myMin = v;
    }

    double getMaxValue() {
        return this.myMax;
    }

    void setMaxValue(double v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int ii;
        int minusPos;
        String significantNumbers;
        int exponentIndex;
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        String numbersOnlyString = "";
        int start = 0;
        if (this.myMin < 0.0 && str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        char[] chars = str.toCharArray();
        String currentText = this.getText(0, this.getLength());
        boolean periodExists = currentText.indexOf(46) != -1;
        boolean exponentExists = currentText.indexOf(101) != -1;
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            if (!(chars[i] != '.' && chars[i] != ',' || periodExists)) {
                numbersOnlyString = numbersOnlyString + ".";
                continue;
            }
            if (!(chars[i] != 'e' && chars[i] != 'E' || exponentExists)) {
                numbersOnlyString = numbersOnlyString + "e";
                continue;
            }
            if (chars[i] == '-' && numbersOnlyString.endsWith("e")) {
                numbersOnlyString = numbersOnlyString + "-";
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits '0-9' and '.' allowed");
        }
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals(".") || proposedResult.equals("-") || proposedResult.equals("-.")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        int indexOfExponent = proposedResult.indexOf(101);
        if (indexOfExponent > -1) {
            String startStr = proposedResult.substring(0, indexOfExponent);
            String endStr = proposedResult.substring(indexOfExponent + 1);
            proposedResult = startStr + "e0" + endStr;
        }
        if ((exponentIndex = (significantNumbers = proposedResult).toLowerCase().indexOf("e")) >= 0) {
            significantNumbers = significantNumbers.substring(0, exponentIndex);
        }
        if ((minusPos = significantNumbers.indexOf(45)) >= 0) {
            significantNumbers = significantNumbers.substring(minusPos + 1);
        }
        for (ii = significantNumbers.length() - 1; 0 <= ii; --ii) {
            if (significantNumbers.charAt(ii) == '0') continue;
            significantNumbers = significantNumbers.substring(0, ii + 1);
            break;
        }
        for (ii = 0; ii < significantNumbers.length(); ++ii) {
            if (significantNumbers.charAt(ii) == '0' || significantNumbers.charAt(ii) == '.' || significantNumbers.charAt(ii) == ',' || this.mySignificance >= significantNumbers.length() - ii) continue;
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Significance, max " + this.mySignificance + " digits are allowed");
            return;
        }
        try {
            double doubleProposedResult = Double.parseDouble(proposedResult);
            if (doubleProposedResult <= this.myMax && doubleProposedResult >= this.myMin) {
                super.insertString(offs, numbersOnlyString, a);
            } else {
                RmaDefs.getInstance().controlledBeep();
                StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.myMin + " >= " + proposedResult + " <= " + this.myMax);
            }
        }
        catch (NumberFormatException e) {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
        }
    }

    @Override
    public boolean isValid(String value) {
        int exp;
        if (value == null) {
            return false;
        }
        String pattern = "^[-+]?(\\d*[.,])?\\d+(e-?\\d+)?$";
        String v = value.toLowerCase();
        if (!Pattern.matches(pattern, v)) {
            return false;
        }
        if (v.startsWith("-")) {
            v = v.substring(1);
        }
        exp = (exp = v.indexOf(101)) < 0 ? v.length() : exp;
        v = v.substring(0, exp);
        v = v.replaceFirst("[.,]", "");
        while (v.startsWith("0")) {
            v = v.substring(1);
        }
        while (v.length() != 0 && v.endsWith("0")) {
            v = v.substring(0, v.length() - 1);
        }
        return v.length() <= this.mySignificance;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

