/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FilteringStringDocument
extends PlainDocument
implements FieldValidation {
    private Pattern pattern = null;
    private String patternString = "[";
    private boolean hasFilteringCharacters = false;

    public FilteringStringDocument() {
    }

    public FilteringStringDocument(Vector<Character> validChars) {
        if (!validChars.isEmpty()) {
            Iterator<Character> i = validChars.iterator();
            String specialRegExpCharacters = "*\\[$]?+.^";
            while (i.hasNext()) {
                char c = i.next().charValue();
                if (specialRegExpCharacters.contains("" + c)) {
                    this.patternString = this.patternString + "\\" + c;
                    continue;
                }
                this.patternString = this.patternString + c;
            }
            this.patternString = this.patternString + "]*";
            this.pattern = Pattern.compile(this.patternString);
            this.hasFilteringCharacters = true;
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.hasFilteringCharacters) {
            super.insertString(offs, str, a);
            return;
        }
        Matcher matcher = this.pattern.matcher(str);
        String replacedCharacters = str;
        if (!matcher.matches()) {
            Pattern p = Pattern.compile("[^" + this.patternString.substring(1));
            Matcher replaceMatcher = p.matcher(str);
            replacedCharacters = replaceMatcher.replaceAll(" ");
        }
        super.insertString(offs, replacedCharacters, a);
    }

    @Override
    public void enableValidation(boolean enable) {
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }

    @Override
    public boolean isValid(String value) {
        if (this.pattern == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

