/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.ere.math.RatingDecimal;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RatingDecimalDocument
extends PlainDocument
implements FieldValidation {
    private boolean myAllowNegativeInput;
    private boolean myAllowEmpty;
    private RatingDecimal myMin = null;
    private RatingDecimal myMax = null;
    private boolean myIsEnabled = true;
    private StatusInterface myStatusHandler = new RMAStatusInterface();

    public RatingDecimalDocument() {
        this(false, true);
    }

    public RatingDecimalDocument(RatingDecimal min, RatingDecimal max) {
        this(false, true, min, max);
    }

    public RatingDecimalDocument(boolean allowEmpty, boolean allowNegativeInput) {
        this.myAllowEmpty = allowEmpty;
        this.myAllowNegativeInput = allowNegativeInput;
    }

    public RatingDecimalDocument(boolean allowEmpty, boolean allowNegativeInput, RatingDecimal min, RatingDecimal max) {
        this(allowEmpty, allowNegativeInput);
        if (min == null) {
            throw new IllegalArgumentException("Minimum value must be provided");
        }
        if (max == null) {
            throw new IllegalArgumentException("Maximum value must be provided");
        }
        if (min.isMoreThanOrEqual(max)) {
            throw new IllegalArgumentException("Defined min value " + min + " is more than or equal to max value " + max);
        }
        this.myMin = min;
        this.myMax = max;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        this.myStatusHandler.printMessage("");
        if (!this.myIsEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (proposedResult.length() == 0 || !this.isProperInputString(proposedResult)) {
            return;
        }
        if (proposedResult.equals("-")) {
            super.insertString(offs, str, a);
            return;
        }
        try {
            proposedResult = this.adjustStringForAcceptedInput(proposedResult);
            RatingDecimal rd = new RatingDecimal(proposedResult);
            if (this.myMin != null && this.myMax != null && (rd.isLessThan(this.myMin) || rd.isMoreThan(this.myMax))) {
                this.alert("Value out of range, must be " + this.myMin + " <= value <= " + this.myMax + ".");
            }
            super.insertString(offs, str, a);
        }
        catch (NumberFormatException e) {
            this.alert("Not a valid number.");
        }
        catch (ArithmeticException ae) {
            this.alert("Number out of range.");
        }
    }

    private String adjustStringForAcceptedInput(String str) {
        String ret = str;
        int last = ret.length() - 1;
        int nextToLast = last - 1;
        if (this.isExponent(ret, last)) {
            ret = ret.substring(0, last);
        } else if (this.isMinus(ret, last) && nextToLast >= 0 && this.isExponent(ret, nextToLast)) {
            ret = ret.substring(0, nextToLast);
        }
        return ret;
    }

    private boolean isProperInputString(String str) {
        int minus = str.lastIndexOf("-");
        if (minus > 0 && !this.isExponent(str, minus - 1)) {
            this.alert("Malplaced minus sign.");
            return false;
        }
        if (!this.myAllowNegativeInput && this.isMinus(str, 0)) {
            this.alert("Negative numbers not allowed.");
            return false;
        }
        if (this.isExponent(str, 0)) {
            this.alert("Malplaced exponent sign.");
            return false;
        }
        if (this.firstIndexOfExponent(str) != this.lastIndexOfExponent(str)) {
            this.alert("Malplaced exponent sign.");
            return false;
        }
        return true;
    }

    private int firstIndexOfExponent(String s) {
        int e = s.indexOf(101);
        int E = s.indexOf(69);
        return e >= 0 && E >= 0 ? Math.min(e, E) : Math.max(e, E);
    }

    private int lastIndexOfExponent(String s) {
        int e = s.lastIndexOf(101);
        int E = s.lastIndexOf(69);
        return Math.max(e, E);
    }

    private boolean isMinus(String s, int idx) {
        return s.charAt(idx) == '-';
    }

    private boolean isExponent(String s, int idx) {
        return Character.toUpperCase(s.charAt(idx)) == 'E';
    }

    private void alert(String msg) {
        this.myStatusHandler.beep();
        this.myStatusHandler.printMessage(msg);
    }

    @Override
    public void enableValidation(boolean enable) {
        this.myIsEnabled = enable;
    }

    @Override
    public boolean isValid(String value) {
        if (value.equals("")) {
            return this.myAllowEmpty;
        }
        if (value.equals("-")) {
            return false;
        }
        if (this.isMinus(value, 0) && !this.myAllowNegativeInput) {
            return false;
        }
        if (this.isExponent(value, 0)) {
            return false;
        }
        try {
            RatingDecimal proposedResult = new RatingDecimal(value);
            if (this.myMax != null && this.myMin != null) {
                return proposedResult.isMoreThanOrEqual(this.myMin) && proposedResult.isLessThanOrEqual(this.myMax);
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }
}

