/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TimeDocument
extends PlainDocument
implements FieldValidation {
    private boolean isEnabled = true;
    private String myRegExpString = "^\\d\\d?:\\d\\d?:\\d\\d?";

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentString;
        StatusPanel.getInstance().setStatusMsg("");
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String stringToInsert = str;
        char[] chars = stringToInsert.toCharArray();
        if (offs == 0) {
            while (chars.length > 0 && chars[0] == ' ') {
                stringToInsert = stringToInsert.substring(1);
                chars = stringToInsert.toCharArray();
            }
        }
        if ((currentString = this.getText(0, this.getLength())).length() + chars.length <= 8 && this.containsAllowedChars(chars)) {
            String beforeOffset = currentString.substring(0, offs);
            String afterOffset = currentString.substring(offs, currentString.length());
            String proposedResult = beforeOffset + stringToInsert + afterOffset;
            if (this.isValid(proposedResult)) {
                StatusPanel.getInstance().setStatusMsg("");
                super.insertString(offs, stringToInsert, a);
                return;
            }
            if (proposedResult.length() < 8) {
                StatusPanel.getInstance().setStatusMsg("Format: HH:mm:ss");
                super.insertString(offs, stringToInsert, a);
                return;
            }
            StatusPanel.getInstance().setStatusMsg("Format: HH:mm:ss");
        } else {
            RmaDefs.getInstance().controlledBeep();
            StatusPanel.getInstance().setStatusMsg("Only digits 0-9, and ':' allowed. Format: HH:mm:ss");
        }
    }

    private boolean containsAllowedChars(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i]) || chars[i] == ':') continue;
            return false;
        }
        return true;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isValid(String value) {
        try {
            Pattern matcher = Pattern.compile(this.myRegExpString);
            if (!matcher.matcher(value).matches()) {
                return false;
            }
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            formatter.setLenient(false);
            formatter.parse(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }
}

