/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.Decimal;
import ericsson.vareditor.documents.FloatsOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class DecimalVariable
extends AbstractNumberStringVariable {
    public DecimalVariable(String label, Decimal value) {
        super(label);
        this.myValue = value.toString();
    }

    public DecimalVariable(String label, String value) {
        super(label, value);
    }

    public DecimalVariable(DecimalVariable v) {
        super(v);
        this.myValue = v.myValue;
    }

    @Override
    public Object clone() {
        return new DecimalVariable(this);
    }

    @Override
    public String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        if ("-".equals(value)) {
            return value;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return new Decimal(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "Decimal";
    }

    public Class<Decimal> getValueClass() {
        return Decimal.class;
    }

    @Override
    public int getFormat() {
        return 2011;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new FloatsOnlyDocument(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

