/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.MonetaryUnits;
import ericsson.vareditor.documents.FloatsOnlyDocument;
import ericsson.vareditor.variable.AbstractNumberStringVariable;

public class MonetaryUnitsVariable
extends AbstractNumberStringVariable {
    public MonetaryUnitsVariable(String label, MonetaryUnits value) {
        super(label);
        this.myValue = value.toString();
    }

    public MonetaryUnitsVariable(String label, String value) {
        super(label, value);
    }

    public MonetaryUnitsVariable(MonetaryUnitsVariable v) {
        super(v);
        this.myValue = v.myValue;
    }

    @Override
    public Object clone() {
        return new MonetaryUnitsVariable(this);
    }

    @Override
    protected String getEditorValue() {
        String value = super.getEditorValue();
        if (value == null) {
            return null;
        }
        if ("-".equals(value)) {
            return value;
        }
        return value;
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid(value)) {
            return MonetaryUnits.valueOf(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "MonetaryUnits";
    }

    public Class<MonetaryUnits> getValueClass() {
        return MonetaryUnits.class;
    }

    @Override
    public int getFormat() {
        return 2010;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new FloatsOnlyDocument(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }
}

