/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.vareditor.variable.ListVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

public class MultiBoolVariable<T extends Enum<T>>
extends ListVariable<T> {
    private static final Color BACKGROUND_COLOR = UIManager.getColor("Panel.background");
    private MultiBoolEditor myEditor;
    private boolean myEnableMultiSelect;

    public MultiBoolVariable(String label, T[] items, T[] selected) {
        this(label, (Enum[])items, (Enum[])selected, true, true);
    }

    public MultiBoolVariable(String label, T[] items, T[] selected, boolean enableMultiSelect, boolean mustHaveSelection) {
        super(label, items, selected, enableMultiSelect, mustHaveSelection);
        this.myEnableMultiSelect = enableMultiSelect;
    }

    @Override
    public Component getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new MultiBoolEditor();
            this.addVariableChangeListener(this.myEditor);
        }
        return this.myEditor;
    }

    @Override
    protected boolean editorHasBeenCreated() {
        return this.myEditor != null;
    }

    private class MultiBoolEditor
    extends JPanel
    implements VariableChangeListener {
        private final JToggleButton[] mySelections;
        private final ListSelectionModel myModel;
        private ButtonGroup myButtonGroup = null;

        public MultiBoolEditor() {
            this.mySelections = new JToggleButton[((Enum[])MultiBoolVariable.this.getItems()).length];
            this.myModel = (ListSelectionModel)MultiBoolVariable.this.getModel();
            this.initPanel();
        }

        private void initPanel() {
            this.setLayout(new BoxLayout(this, 0));
            for (int i = 0; i < ((Enum[])MultiBoolVariable.this.getItems()).length; ++i) {
                String label = ((Enum[])MultiBoolVariable.this.getItems())[i].toString();
                boolean selected = this.myModel.isSelectedIndex(i);
                this.mySelections[i] = this.createToggleButton(label, selected);
                this.mySelections[i].addActionListener(new ToggleButtonActionListener(i));
                this.mySelections[i].setOpaque(false);
                this.mySelections[i].setName(label);
                this.add(this.mySelections[i]);
                this.add(Box.createRigidArea(new Dimension(2, 0)));
            }
            if (!MultiBoolVariable.this.myEnableMultiSelect) {
                this.myButtonGroup = new ButtonGroup();
                for (JToggleButton button : this.mySelections) {
                    this.myButtonGroup.add(button);
                }
            }
            this.add(Box.createHorizontalGlue());
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            this.updateEditorBackground(MultiBoolVariable.this.isValueValid());
        }

        private JToggleButton createToggleButton(String label, boolean selected) {
            return MultiBoolVariable.this.myEnableMultiSelect ? new JCheckBox(label, selected) : new JRadioButton(label, selected);
        }

        @Override
        public void valueChanged(final VariableChangeEvent event) {
            EDT.runAndWait(new Runnable(){

                @Override
                public void run() {
                    MultiBoolEditor.this.updateToggleButtonSelectionFromModel();
                    MultiBoolEditor.this.updateEditorBackground(event.isValueValid());
                }
            });
        }

        private void updateEditorBackground(boolean valid) {
            this.setBackground(valid ? BACKGROUND_COLOR : Color.red);
        }

        private void updateToggleButtonSelectionFromModel() {
            if (this.myModel.isSelectionEmpty() && !MultiBoolVariable.this.myEnableMultiSelect) {
                this.myButtonGroup.clearSelection();
            } else {
                for (int i = 0; i < this.mySelections.length; ++i) {
                    boolean selectedInModel = this.myModel.isSelectedIndex(i);
                    if (selectedInModel == this.mySelections[i].isSelected()) continue;
                    this.mySelections[i].setSelected(selectedInModel);
                }
            }
        }

        private class ToggleButtonActionListener
        implements ActionListener {
            private final int myIndex;

            ToggleButtonActionListener(int index) {
                this.myIndex = index;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton source = (JToggleButton)e.getSource();
                if (source.isSelected()) {
                    MultiBoolEditor.this.myModel.addSelectionInterval(this.myIndex, this.myIndex);
                } else {
                    MultiBoolEditor.this.myModel.removeSelectionInterval(this.myIndex, this.myIndex);
                }
            }
        }
    }
}

