/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.management.DateUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.BcdStringVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.ButtonVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DecimalVariable;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.FileVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.MonetaryUnitsVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.OctetStringVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.ShortVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.UnsignedInt16Variable;
import ericsson.vareditor.variable.UnsignedInt32Variable;
import ericsson.vareditor.variable.UnsignedInt8Variable;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.text.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Variable
implements Cloneable {
    @Deprecated
    public ImageIcon myIcon = null;
    public static final int UNKNOWN = -1;
    public static final int STRING = 0;
    public static final int BOOLEAN = 1;
    public static final int STRING_DROPDOWN = 2;
    public static final int INDEX_DROPDOWN = 3;
    public static final int MULTILINE_STRING = 4;
    public static final int INTEGER = 5;
    public static final int FILE = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int DATE = 9;
    public static final int SHORT = 10;
    public static final int OBJECT_LIST = 11;
    public static final int ULONG = 12;
    public static final int UINTEGER = 13;
    public static final int USHORT = 14;
    public static final int OBJECT_DROPDOWN = 99;
    public static final int BUTTON = 999;
    public static final int TIME_OF_DAY = 1000;
    public static final int UNSIGNEDINT32 = 2000;
    public static final int UNSIGNEDINT16 = 2001;
    public static final int UNSIGNEDINT8 = 2002;
    public static final int MONETARYUNITS = 2010;
    public static final int DECIMAL = 2011;
    public static final int OCTETSTRING = 2020;
    public static final int BCDSTRING = 2030;
    public static final int SERVICEOFFERINGS = 2040;
    public static final int TIME = 2060;
    public static final int TIMEANDDATE = 2080;
    public static final int RATINGDECIMAL = 3000;
    public static final int ARRAY = 5000;
    public static final int LIST = 6000;
    public static final int INFO = 9999;
    protected BaseVariable myVariable;
    private boolean hasListeners = false;

    protected Variable() {
    }

    @Deprecated
    public Variable(String label, UnsignedInt32 value) {
        this.myVariable = new UnsignedInt32Variable(label, value);
    }

    @Deprecated
    public Variable(String label, UnsignedInt16 value) {
        this.myVariable = new UnsignedInt16Variable(label, value);
    }

    @Deprecated
    public Variable(String label, UnsignedInt8 value) {
        this.myVariable = new UnsignedInt8Variable(label, value);
    }

    @Deprecated
    public Variable(String label, MonetaryUnits value) {
        this.myVariable = new MonetaryUnitsVariable(label, value);
    }

    @Deprecated
    public Variable(String label, Decimal value) {
        this.myVariable = new DecimalVariable(label, value);
    }

    @Deprecated
    public Variable(String label, Time value) {
        this.myVariable = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME, value.getCalendar());
    }

    @Deprecated
    public Variable(String label, OctetString value) {
        this.myVariable = new OctetStringVariable(label, value);
    }

    @Deprecated
    public Variable(String label, OctetString value, int selected) {
        this.myVariable = new OctetStringVariable(label, value, selected);
    }

    @Deprecated
    public Variable(String label, BcdString value) {
        this.myVariable = new BcdStringVariable(label, value);
    }

    @Deprecated
    public Variable(String label, String value) {
        this.myVariable = new StringVariable(label, value);
    }

    @Deprecated
    public Variable(String value) {
        this.myVariable = new ButtonVariable(value);
    }

    @Deprecated
    public Variable(String label, String value, boolean multiLine) {
        this.myVariable = multiLine ? new MultilineStringVariable(label, value) : new StringVariable(label, value);
    }

    @Deprecated
    public Variable(String label, boolean value) {
        this.myVariable = new BoolVariable(label, value);
    }

    @Deprecated
    public Variable(String label, String selected, String[] choices) {
        this.myVariable = new DropDownVariable(label, (Object)selected, (Object[])choices);
    }

    @Deprecated
    public Variable(String label, Object selected, Object[] choices) {
        this.myVariable = new DropDownVariable(label, selected, choices);
    }

    @Deprecated
    public Variable(String label, int selectedIndex, String[] choices) {
        this.myVariable = new DropDownVariable(label, selectedIndex, (Object[])choices);
    }

    @Deprecated
    public Variable(String label, int intValue) {
        this.myVariable = new IntegerVariable(label, intValue);
    }

    @Deprecated
    public Variable(String label, long longValue) {
        this.myVariable = new LongVariable(label, longValue);
    }

    @Deprecated
    public Variable(String label, double doubleValue) {
        this.myVariable = new DoubleVariable(label, doubleValue);
    }

    @Deprecated
    public Variable(String label, Date dateValue) {
        this.myVariable = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE, DateUtil.dateToCalendar(dateValue));
    }

    @Deprecated
    public Variable(String label, short shortValue) {
        this.myVariable = new ShortVariable(label, shortValue);
    }

    @Deprecated
    public Variable(Variable v) {
        this.myVariable = (BaseVariable)v.myVariable.clone();
    }

    @Deprecated
    public Variable(String label, Object[] value) {
        this.myVariable = new ArrayVariable(label, value);
    }

    @Deprecated
    public Variable(String label, String value, int format) {
        switch (format) {
            case 4: {
                this.myVariable = new MultilineStringVariable(label, value);
                return;
            }
            case 6: {
                this.myVariable = new StringVariable(label, value);
                return;
            }
            case 1000: {
                this.myVariable = new DateAndTimeVariable(label, DateAndTimeVariable.Content.TIME, value);
                return;
            }
        }
        this.myVariable = null;
    }

    @Deprecated
    public Variable(String label, String value, ListModel theModel, MouseListener mListener) {
        this.myVariable = null;
    }

    @Deprecated
    public Variable(String label, ArrayModel valueModel) {
        this.myVariable = new ArrayVariable(label, valueModel);
    }

    @Deprecated
    public Variable(String label, JComponent comp) {
        this.myVariable = null;
    }

    @Deprecated
    public Variable(String label, Object value, int format, Object theModel) {
        switch (format) {
            case 0: {
                this.myVariable = new StringVariable(label, value.toString(), (Document)theModel);
                return;
            }
            case 4: {
                this.myVariable = new MultilineStringVariable(label, value.toString(), (Document)theModel);
                return;
            }
            case 8: {
                this.myVariable = new DoubleVariable(label, (Double)value);
                ((StringVariable)this.myVariable).setModel((Document)theModel);
                return;
            }
        }
        throw new RuntimeException("Format not " + format + " supported");
    }

    @Deprecated
    public void setDataItem(DataItem item) {
        this.myVariable.setDataItem(item);
    }

    public void addVariableChangeListener(VariableChangeListener listener) {
        this.myVariable.addVariableChangeListener(listener);
    }

    public void removeVariableChangeListener(VariableChangeListener listener) {
        this.myVariable.removeVariableChangeListener(listener);
    }

    public boolean isModified() {
        return this.myVariable.isModified();
    }

    public void resetModified() {
        this.myVariable.resetModified();
    }

    public void setModified(boolean isModified) {
        this.myVariable.setModified(isModified);
    }

    public Object clone() {
        return this.myVariable.clone();
    }

    public Object getValueObject() {
        return this.myVariable.getValueObject();
    }

    public String toString() {
        return this.myVariable.toString();
    }

    public void setValue(Object v) {
        this.myVariable.setValue(v);
    }

    public void setValue(String v) {
        this.myVariable.setValue(v);
    }

    public String getTypename() {
        return this.myVariable.getTypename();
    }

    public void setKey(String key) {
        this.myVariable.setKey(key);
    }

    public String getKey() {
        return this.myVariable.getKey();
    }

    public String getLabel() {
        return this.myVariable.getLabel();
    }

    public void setLabel(String l) {
        this.myVariable.setLabel(l);
    }

    public int getFormat() {
        return this.myVariable.getFormat();
    }

    public boolean isValueValid() {
        return this.myVariable.isValueValid();
    }

    public Class<?> getValueClass() {
        return this.myVariable.getValueClass();
    }

    @Deprecated
    public boolean getAllowEdit() {
        return this.myVariable.getAllowEdit();
    }

    public boolean isAllowEdit() {
        return this.myVariable.isAllowEdit();
    }

    public void setAllowEdit(boolean allow) {
        this.myVariable.setAllowEdit(allow);
    }

    public void setEnabled(boolean enabled) {
        if (this.isAllowEdit()) {
            this.myVariable.getEditor().setEnabled(enabled);
        }
    }

    public Component getRenderer() {
        return this.myVariable.getRenderer();
    }

    public Component getEditor() {
        return this.myVariable.getEditor();
    }

    public void setHelpId(String helpId) {
        this.myVariable.setHelpId(helpId);
    }

    @Deprecated
    public void setActionListener(ActionListener listener) {
        this.hasListeners = true;
    }

    public Object getModel() {
        return this.myVariable.getModel();
    }

    public boolean hasListener() {
        return this.hasListeners;
    }

    @Deprecated
    public void setChoices(Object[] c) {
    }

    public void writeXML(PrintWriter out) {
        this.myVariable.writeXML(out);
    }

    public StringBuffer getXMLDefinition(String xmlTag) {
        return this.myVariable.getXMLDefinition(xmlTag);
    }

    public String getValueString() {
        return this.myVariable.getValueString();
    }

    public String getMultipleSelectValueString() {
        return this.myVariable.getValueString();
    }

    public void setHorizontalAlignment(int alignment) {
        this.myVariable.setHorizontalAlignment(alignment);
    }

    public void setFocusListenerForEditor(FocusListener fl) {
        this.myVariable.setFocusListenerForEditor(fl);
    }

    public static Variable create(Node iterator) throws Exception {
        if ("Variable".equals(iterator.getNodeName())) {
            NamedNodeMap attr = iterator.getAttributes();
            Node node = attr.getNamedItem("label");
            if (node == null) {
                throw new IllegalArgumentException("Missing attribute: label");
            }
            String label = node.getNodeValue();
            node = attr.getNamedItem("key");
            String key = node == null ? label : node.getNodeValue();
            node = attr.getNamedItem("format");
            if (node == null) {
                throw new IllegalArgumentException("Missing attribute: format");
            }
            int format = Integer.parseInt(node.getNodeValue());
            node = attr.getNamedItem("value");
            String valueString = node == null ? (format == 4 ? XMLUtil.getFirstTextContent(iterator) : "") : node.getNodeValue();
            BaseVariable v = null;
            switch (format) {
                case 0: {
                    v = new StringVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 1: {
                    v = new BoolVariable(label, Boolean.valueOf(valueString));
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2: {
                    v = new DropDownVariable(label);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 3: {
                    v = new DropDownVariable(label);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 4: {
                    v = new MultilineStringVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 5: {
                    v = new IntegerVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 6: {
                    v = new FileVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 7: {
                    v = new LongVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 8: {
                    v = new DoubleVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 9: {
                    v = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 10: {
                    v = new ShortVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 11: {
                    return null;
                }
                case 99: {
                    v = new DropDownVariable(label);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 999: {
                    v = new ButtonVariable(label);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 1000: {
                    v = new DateAndTimeVariable(label, DateAndTimeVariable.Content.TIME, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2000: {
                    v = new UnsignedInt32Variable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2001: {
                    v = new UnsignedInt16Variable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2002: {
                    v = new UnsignedInt8Variable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2010: {
                    v = new MonetaryUnitsVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2011: {
                    v = new DecimalVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 3000: {
                    v = new RatingDecimalVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2020: {
                    v = new OctetStringVariable(label, new OctetString(""));
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2030: {
                    v = new BcdStringVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 2060: {
                    v = new DateAndTimeVariable(label, DateAndTimeVariable.Content.DATE_TIME, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 5000: {
                    v = new ArrayVariable(label);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
                case 9999: {
                    v = new InfoVariable(label, valueString);
                    v.initFromXml(iterator, valueString, key, format);
                    return v;
                }
            }
        }
        return null;
    }

    public Variable setSelected(boolean selected) {
        return this.myVariable.setSelected(selected);
    }

    public boolean isSelected() {
        return this.myVariable.isSelected();
    }

    public void addSelectedActionListener(Object listener) {
        this.myVariable.addSelectedActionListener(listener);
    }

    public void editFinished() {
        this.myVariable.editFinished();
    }

    public <T, U extends T> void addInfo(InfoKey<T> key, U info) {
        this.myVariable.addInfo(key, info);
    }

    public <T> T getInfo(InfoKey<T> key) {
        return this.myVariable.getInfo(key);
    }

    public void setIcon(ImageIcon icon) {
        this.myIcon = icon;
    }

    public ImageIcon getIcon() {
        return this.myIcon;
    }

    public static class InfoKey<T> {
    }
}

