/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.ObjectArrayDialogPanel;
import ericsson.vareditor.variable.array.ObjectArrayEditor;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JTable;

public class ObjectArrayEditDialog
extends JDialog
implements ActionListener {
    protected ObjectArrayDialogPanel myEditPanel;
    protected static final String LBL_DIALOG_TITLE = "Tree Defined Field";
    protected static final int ACTION_ADD = 0;
    protected static final int ACTION_EDIT = 1;
    protected static final int ACTION_DELETE = 2;
    private final int currentAction;
    private final JTable myTable;
    private VarTableModel myTableModel;
    private ObjectArrayEditor myVariablePanel;
    private final ObjectArrayModel myData;
    private Object[] myOldRowValues = null;
    private static final String LBL_TITLED_BORDER = " Edit details ";

    public ObjectArrayEditDialog(Window window, ObjectArrayEditor panel, JTable table, int action) {
        super(window, LBL_DIALOG_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.currentAction = action;
        this.myTable = table;
        this.myData = (ObjectArrayModel)this.myTable.getModel();
        if (this.currentAction == 1) {
            this.myOldRowValues = this.myData.getRow(this.myTable.getSelectedRow());
            this.myTableModel = this.myData.createVarTableModel(this.myData.getRow(this.myTable.getSelectedRow()));
        } else {
            this.myTableModel = this.myData.createVarTableModel();
        }
        this.myVariablePanel = panel;
        this.initiate(this.myTableModel);
        this.setLocationRelativeTo(window);
    }

    private void initiate(VarTableModel model) {
        this.myEditPanel = new ObjectArrayDialogPanel(false, LBL_TITLED_BORDER);
        this.myEditPanel.init(model);
        this.myEditPanel.addOkActionListener(this);
        this.myEditPanel.addCancelActionListener(this);
        this.add(this.myEditPanel);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean shouldClose = true;
        if (e.getActionCommand().equals("OK")) {
            shouldClose = true;
            Object[] obj = new Object[this.myTableModel.getData().size()];
            int indx = 0;
            for (Variable var : this.myTableModel.getData()) {
                obj[indx] = var.getValueObject();
                ++indx;
            }
            if (!this.allVariablesValid()) {
                DialogFactory.getErrorDialog(this, "Field holds invalid value", "One or more fields holds an invalid value");
                shouldClose = false;
            } else if (this.currentAction == 0) {
                if (this.myData.checkIfColumnUnique(obj)) {
                    this.myVariablePanel.addNewRow(obj);
                    shouldClose = true;
                } else {
                    DialogFactory.getErrorDialog(this, "Row must be unique", "Value(s) in " + this.myData.getUniqueColumnName() + " must be unique");
                    shouldClose = false;
                }
            } else if (this.currentAction == 1) {
                if (this.hasUniqueId() && !this.hasUniqueValuesChanged(obj)) {
                    if (this.myData.checkIfColumnUnique(obj)) {
                        this.myVariablePanel.updateSelectedRow(obj);
                        shouldClose = true;
                    } else {
                        DialogFactory.getErrorDialog(this, "Row must be unique", "Value(s) in " + this.myData.getUniqueColumnName() + " must be unique");
                        shouldClose = false;
                    }
                } else {
                    this.myVariablePanel.updateSelectedRow(obj);
                }
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            shouldClose = true;
        }
        if (shouldClose) {
            this.setVisible(false);
            this.myTable.requestFocus();
        } else {
            this.setVisible(true);
        }
    }

    private boolean hasUniqueValuesChanged(Object[] obj) {
        int[] uniqueColumnIndices;
        for (int index : uniqueColumnIndices = this.myData.getUniqueColumns()) {
            if (this.myOldRowValues[index].equals(obj[index])) continue;
            return false;
        }
        return true;
    }

    private boolean hasUniqueId() {
        return this.myData.getUniqueColumns().length > 0;
    }

    private boolean allVariablesValid() {
        for (Variable var : this.myTableModel.getData()) {
            if (var.isValueValid()) continue;
            return false;
        }
        return true;
    }
}

