/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.variable.array.ObjectArrayEditDialog;
import ericsson.vareditor.variable.array.ObjectArrayEditor;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class ObjectArrayEditMenu
extends JPopupMenu {
    private static final String LBL_DIALOG_TITLE = "Tree Defined Fields";
    public static final String ADD_ICON_FILE = "new_add.gif";
    public static final String DELETE_ICON_FILE = "new_delete.gif";
    public static final String EDIT_ICON_FILE = "new_edit.gif";
    private JMenuItem actionAdd;
    private JMenuItem actionEdit;
    private JMenuItem actionDelete;
    private ObjectArrayModel myModel;
    private JTable myList;
    private ObjectArrayEditor oaEditor;
    private Window myWindow;

    public ObjectArrayEditMenu(Window window, ObjectArrayEditor varPanel) {
        this.myModel = varPanel.getModel();
        this.oaEditor = varPanel;
        this.myWindow = window;
        this.setup();
    }

    private void setup() {
        this.actionAdd = this.createAddValueItem();
        this.actionEdit = this.createEditValueItem();
        this.actionDelete = this.createDeleteValueItem();
        this.add(this.actionAdd);
        this.addSeparator();
        this.add(this.actionEdit);
        this.add(this.actionDelete);
    }

    public void setValues(ObjectArrayModel model, JTable list) {
        this.myModel = model;
        this.myList = list;
    }

    public void enableAction(int selectedRow, boolean editAllowed) {
        this.actionAdd.setEnabled(true);
        this.actionEdit.setEnabled(editAllowed);
        this.actionDelete.setEnabled(editAllowed);
        if (selectedRow < 0) {
            this.actionEdit.setEnabled(false);
            this.actionDelete.setEnabled(false);
        }
    }

    private JMenuItem createAddValueItem() {
        JMenuItem aMenuItem = new JMenuItem();
        ImageIcon aIcon = RmaDefs.getImageIcon(ADD_ICON_FILE);
        aMenuItem.setAction(new AbstractAction("Add value", aIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ObjectArrayEditMenu.this.myModel.getMaxNumberOfRows() > 0 && ObjectArrayEditMenu.this.myModel.getRowCount() >= ObjectArrayEditMenu.this.myModel.getMaxNumberOfRows()) {
                    DialogFactory.getErrorDialog("Limited number of rows", "Max number of rows allowed " + ObjectArrayEditMenu.this.myModel.getMaxNumberOfRows());
                } else {
                    ObjectArrayEditDialog editDialog = new ObjectArrayEditDialog(ObjectArrayEditMenu.this.myWindow, ObjectArrayEditMenu.this.oaEditor, ObjectArrayEditMenu.this.myList, 0);
                    editDialog.setTitle("Tree Defined Fields - Add");
                    editDialog.setVisible(true);
                }
            }
        });
        return aMenuItem;
    }

    private JMenuItem createEditValueItem() {
        JMenuItem aMenuItem = new JMenuItem();
        ImageIcon aIcon = RmaDefs.getImageIcon(EDIT_ICON_FILE);
        aMenuItem.setAction(new AbstractAction("Edit value", aIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectArrayEditDialog editDialog = new ObjectArrayEditDialog(ObjectArrayEditMenu.this.myWindow, ObjectArrayEditMenu.this.oaEditor, ObjectArrayEditMenu.this.myList, 1);
                editDialog.setTitle("Tree Defined Fields - Edit");
                editDialog.setVisible(true);
            }
        });
        return aMenuItem;
    }

    public JMenuItem createDeleteValueItem() {
        JMenuItem aMenuItem = new JMenuItem();
        ImageIcon aIcon = RmaDefs.getImageIcon(DELETE_ICON_FILE);
        aMenuItem.setAction(new AbstractAction("Delete value", aIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                int todo = JOptionPane.showConfirmDialog(GuiServiceCenter.getInstance().getMainWindow(), "Are you sure you want to delete this row? \nThis can not be undone.");
                if (todo == 0) {
                    ObjectArrayEditMenu.this.myModel.removeElementAt(ObjectArrayEditMenu.this.myList.getSelectedRow());
                    ObjectArrayEditMenu.this.myModel.fireTableChanged(new TableModelEvent(ObjectArrayEditMenu.this.myModel));
                }
            }
        });
        return aMenuItem;
    }
}

