/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array.table;

import ericsson.ere.datatype.Amount;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import java.util.ArrayList;

public class TableSorter {
    private ObjectArrayModel model;
    protected ArrayList<?> sortedIndex;

    public TableSorter(ObjectArrayModel model) {
        this.model = model;
    }

    public void sortTable(int column, boolean isAscent) {
        if (this.model.getRowCount() > 1) {
            this.sortTable(column, isAscent, 1);
            this.model.fireTableDataChanged();
        }
    }

    public void sortTable(int column, boolean isAscent, int row) {
        if (row == 0) {
            return;
        }
        if (isAscent) {
            if (this.compare(column, row, row - 1) < 0) {
                this.model.moveUp(row);
                this.sortTable(column, isAscent, row - 1);
            }
            if (++row <= this.model.getRowCount() - 1) {
                this.sortTable(column, isAscent, row);
            }
        } else {
            if (this.compare(column, row, row - 1) > 0) {
                this.model.moveUp(row);
                this.sortTable(column, isAscent, row - 1);
            }
            if (++row <= this.model.getRowCount() - 1) {
                this.sortTable(column, isAscent, row);
            }
        }
    }

    public int compare(int column, int row1, int row2) {
        Object o1 = this.model.getValueAt(row1, column);
        Object o2 = this.model.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return this.compare((Number)o1, (Number)o2);
        }
        if (o1 instanceof Amount && o2 instanceof Amount) {
            return ((Amount)o1).compareTo((Amount)o2);
        }
        return o1.toString().compareTo(o2.toString());
    }

    public int compare(Number o1, Number o2) {
        long n2;
        long n1 = o1.longValue();
        if (n1 < (n2 = o2.longValue())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }
}

