/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.bitpatternutils.BitPatternValue;
import java.util.StringTokenizer;

public class BitPatternData {
    public static final String RANGE_SEP = "-";
    public static final String MASK_SEP = ";";
    private BitPatternValue myFromValue;
    private BitPatternValue myToValue;
    private boolean isRange;
    private DataType myDataType;

    public BitPatternData(DataType dataType) {
        this.myDataType = dataType;
        this.myFromValue = new BitPatternValue(this.myDataType);
        this.myToValue = new BitPatternValue(this.myDataType);
        this.isRange = false;
    }

    private void parseData(String aValue) throws Exception {
        this.isRange = false;
        StringTokenizer tokenizer = new StringTokenizer(aValue, RANGE_SEP);
        if (tokenizer.countTokens() == 2) {
            this.myFromValue = new BitPatternValue(tokenizer.nextToken(), this.myDataType);
            this.myToValue = new BitPatternValue(tokenizer.nextToken(), this.myDataType);
            this.isRange = true;
        } else if (tokenizer.countTokens() <= 1) {
            this.myFromValue = new BitPatternValue(aValue, this.myDataType);
            this.myToValue = new BitPatternValue(this.myDataType);
            this.isRange = false;
        } else {
            throw new Exception("Incorrect value: '" + aValue + "'");
        }
    }

    public void setData(String aValueStr) throws Exception {
        this.parseData(aValueStr);
    }

    public boolean isRange() {
        return this.isRange;
    }

    public void isRange(boolean range) {
        if (range) {
            this.myFromValue.dfltMask();
        }
        this.isRange = range;
    }

    public BitPatternValue getFromValue() {
        return this.myFromValue;
    }

    public BitPatternValue getToValue() {
        return this.myToValue;
    }
}

