/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.UnsignedLong;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BitPatternValue {
    public static final String DFLT_BP_VALUE = "0";
    private static final BigInteger DFLT_VALUE = new BigInteger("0");
    public static final String MASK_SEP = ";";
    private BigInteger myValue;
    private BigInteger myMask;
    private boolean changesMade = false;
    protected EventListenerList changeListeners = new EventListenerList();
    protected ChangeEvent changeEvent = null;
    private final DataType myDataType;

    public BitPatternValue(DataType dataType) {
        this.myDataType = dataType;
        this.setData(DFLT_BP_VALUE);
    }

    public BitPatternValue(String data, DataType dataType) {
        this.myDataType = dataType;
        this.updateData(data);
    }

    public static BigInteger getValueWithAllBitsSet(DataType dataType) {
        switch (dataType) {
            case SHORT: 
            case UNSIGNEDSHORT: {
                return new BigInteger(Integer.toString(65535));
            }
            case INTEGER: 
            case UNSIGNEDINT: {
                return new BigInteger(Long.toString(0xFFFFFFFFL));
            }
            case LONG: 
            case UNSIGNEDLONG: {
                return UnsignedLong.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException(dataType.getTypeName() + " is not supported.");
    }

    public String getData() {
        String maskStr = "";
        String valueStr = this.getValue().toString();
        if (!this.getMask().equals(BitPatternValue.getValueWithAllBitsSet(this.myDataType))) {
            maskStr = maskStr + MASK_SEP + this.getMask().toString();
        }
        return valueStr + maskStr;
    }

    public void setData(String data) {
        this.updateData(data);
        this.fireStateChanged();
    }

    public void setData(BigInteger value, BigInteger mask) {
        this.setValue(value);
        this.setMask(mask);
        this.fireStateChanged();
    }

    public void setData(BitSet value, BitSet mask) {
        this.setData(this.parseBitSetToBigInt(value), this.parseBitSetToBigInt(mask));
    }

    public BigInteger getValue() {
        return this.myValue;
    }

    public BigInteger getValueWithConversionByDataType() {
        return BitPatternValue.convertBigIntegerByDataType(this.myValue, this.myDataType);
    }

    public BigInteger getMask() {
        return this.myMask;
    }

    public BigInteger getMaskWithConversionByDataType() {
        return BitPatternValue.convertBigIntegerByDataType(this.myMask, this.myDataType);
    }

    public void dfltMask() {
        this.setMask(BitPatternValue.getValueWithAllBitsSet(this.myDataType));
    }

    private void setValue(BigInteger value) {
        if (this.myValue != value) {
            this.changesMade = true;
            this.myValue = BitPatternValue.convertBigIntegerToUnsignedByDataType(value, this.myDataType);
        }
    }

    private void setMask(BigInteger mask) {
        if (this.myMask != mask) {
            this.changesMade = true;
            this.myMask = BitPatternValue.convertBigIntegerToUnsignedByDataType(mask, this.myDataType);
        }
    }

    public BitSet getMaskAsBitSet() {
        return this.getBitSet(this.getMask().toString(2));
    }

    public BitSet getValueAsBitSet() {
        return this.getBitSet(this.getValue().toString(2));
    }

    public String toString() {
        return this.getData();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(ChangeListener.class, cl);
    }

    public boolean isEqualTo(BitPatternValue aBPValue) {
        return this.getValue() == aBPValue.getValue() && this.getMask() == aBPValue.getMask();
    }

    public void fireStateChanged() {
        if (!this.changesMade) {
            return;
        }
        Object[] listeners = this.changeListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            this.changeEvent = new ChangeEvent(this);
            ChangeListener cl = (ChangeListener)listeners[i + 1];
            cl.stateChanged(this.changeEvent);
        }
        this.changesMade = false;
    }

    private BitSet getBitSet(String s) {
        BitSet tmpBitSet = new BitSet(this.myDataType.bitSize());
        for (int i = 0; i < this.myDataType.bitSize(); ++i) {
            if (i < s.length()) {
                if (s.substring(s.length() - i - 1, s.length() - i).equals("1")) {
                    tmpBitSet.set(i);
                    continue;
                }
                tmpBitSet.clear(i);
                continue;
            }
            tmpBitSet.clear(i);
        }
        return tmpBitSet;
    }

    static String convertBigIntegerToDecimalString(BigInteger bigInt, DataType dataType) {
        switch (dataType) {
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDLONG: {
                return bigInt.toString();
            }
            case SHORT: {
                return Short.toString(bigInt.shortValue());
            }
            case INTEGER: {
                return Integer.toString(bigInt.intValue());
            }
            case LONG: {
                return Long.toString(bigInt.longValue());
            }
        }
        throw new IllegalArgumentException(dataType.getTypeName() + " is not supported.");
    }

    static String convertBigIntegerToHexString(BigInteger bigInt, DataType dataType) {
        return bigInt.toString(16).toUpperCase();
    }

    private static BigInteger convertBigIntegerByDataType(BigInteger bigInt, DataType dataType) {
        switch (dataType) {
            case SHORT: {
                return BigInteger.valueOf(bigInt.shortValue());
            }
            case INTEGER: {
                return BigInteger.valueOf(bigInt.intValue());
            }
            case LONG: {
                return BigInteger.valueOf(bigInt.longValue());
            }
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDLONG: {
                return bigInt;
            }
        }
        throw new IllegalArgumentException(dataType.getTypeName() + " is not supported.");
    }

    private static BigInteger convertBigIntegerToUnsignedByDataType(BigInteger bigInt, DataType dataType) {
        switch (dataType) {
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDLONG: {
                return bigInt;
            }
            case SHORT: {
                return new BigInteger(DataType.UShortParser(bigInt.shortValue()));
            }
            case INTEGER: {
                return new BigInteger(DataType.UIntegerParser(bigInt.intValue()));
            }
            case LONG: {
                return new BigInteger(DataType.ULongParser(bigInt.longValue()));
            }
        }
        throw new IllegalArgumentException(dataType.getTypeName() + " is not supported.");
    }

    private BigInteger parseBitSetToBigInt(BitSet bs) {
        String binStr = "";
        for (int i = this.myDataType.bitSize() - 1; i >= 0; --i) {
            binStr = bs.get(i) ? binStr + "1" : binStr + DFLT_BP_VALUE;
        }
        return new BigInteger(binStr, 2);
    }

    private void updateData(String aValue) {
        StringTokenizer tokenizer = new StringTokenizer(aValue, MASK_SEP);
        BigInteger value = DFLT_VALUE;
        BigInteger mask = BitPatternValue.getValueWithAllBitsSet(this.myDataType);
        if (tokenizer.countTokens() == 1) {
            value = new BigInteger(tokenizer.nextToken());
        } else if (tokenizer.countTokens() == 2) {
            value = new BigInteger(tokenizer.nextToken());
            mask = new BigInteger(tokenizer.nextToken());
        }
        this.setValue(value);
        this.setMask(mask);
    }
}

