/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.selectiontree.structures.treedefinedfields.TDFAdditionalDataType;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDefs;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalType;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFDropDownVariable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeDefinedFieldHelper {
    private ClassRepository myClassRepository;

    public TreeDefinedFieldHelper(ClassRepository classRep) {
        this.myClassRepository = classRep;
    }

    @Deprecated
    public TreeDefinedFieldHelper(ClassRepository classRep, List<TDFAdditionalDataType> dtList) {
        this(classRep);
    }

    public ClassRepository getClassRepository() {
        return this.myClassRepository;
    }

    public Variable getVariableOfDataType(String dataType, String label, NamedNodeMap attributes, String min, String max, boolean additionalVar) {
        Variable var;
        DataType dt = DataType.lookup(dataType);
        if (dt == DataType.AMOUNT) {
            var = VariableFactory.createAmountVariable(label, null, this.myClassRepository, null, false);
        } else {
            Object value = min != null && max != null ? min : (dt != null ? dt.createDefaultInstance() : null);
            var = VariableFactory.getVariableOfDataType(dataType, label, attributes, min, max, value);
        }
        return var;
    }

    public Variable getTDFAdditionalVariableOfDataType(String dataType, String label, Node node) {
        if (TDFDropDownVariable.TYPE.equals(dataType)) {
            TDFDropDownVariable var = new TDFDropDownVariable(label);
            var.initFromXml(node, "", label, 2);
            return var;
        }
        return this.getVariableOfDataType(dataType, label, null, null, null, true);
    }

    public List<String> getAllTreeDefinedFields() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < EreDefs.dataTypeArray.length; ++i) {
            for (String fieldName : this.myClassRepository.getFieldNamesOfType(i)) {
                if (!"INTERNAL".equals(this.myClassRepository.getFieldDefinitionByName(fieldName).getParameterType())) continue;
                list.add(fieldName);
            }
        }
        return list;
    }

    public boolean checkIfFieldIsTreeDefinedField(String fieldName) {
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(fieldName);
        return fd != null && "INTERNAL".equals(fd.getParameterType());
    }

    public String[] getTreeDefinedFieldsOfDataType(String DataType2) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < EreDefs.dataTypeArray.length; ++i) {
            for (String fieldName : this.myClassRepository.getFieldNamesOfType(i)) {
                if (!"INTERNAL".equals(this.myClassRepository.getFieldDefinitionByName(fieldName).getParameterType()) || !DataType2.equals(this.myClassRepository.getFieldDefinitionByName(fieldName).getDataType())) continue;
                list.add(fieldName);
            }
        }
        String[] retArray = new String[list.size()];
        for (int ii = 0; ii < retArray.length; ++ii) {
            retArray[ii] = (String)list.get(ii);
        }
        return retArray;
    }

    public String[] getEnumNames(String fieldName) {
        return FieldDefinitionHelper.getEnumNames(this.myClassRepository, fieldName);
    }

    public String[] getEnumValues(String fieldName) {
        return FieldDefinitionHelper.getEnumValues(this.myClassRepository, fieldName);
    }

    public String getMaxValue(String fieldName) {
        FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fieldDefinition != null && (fieldDefinition.hasUtil("EditComponent") || fieldDefinition.hasUtil("InputRestriction")) && ("ericsson.ere.gui.util.NumberRangeEditor".equals(fieldDefinition.getUtilClass("EditComponent")) || "Range".equals(fieldDefinition.getUtilClass("InputRestriction")))) {
            Element editComponentElement = XMLUtil.getNamedElement("EditComponent", fieldDefinition.getDefinitionNode().getChildNodes());
            NodeList rangeComponents = null;
            if (editComponentElement != null) {
                rangeComponents = editComponentElement.getElementsByTagName("Range");
            }
            Element inputRestrictionElement = XMLUtil.getNamedElement("InputRestriction", fieldDefinition.getDefinitionNode().getChildNodes());
            NodeList rangeComponents2 = null;
            ArrayList<Element> mergedComponents = new ArrayList<Element>();
            if (inputRestrictionElement != null) {
                rangeComponents2 = inputRestrictionElement.getElementsByTagName("Range");
            }
            if (rangeComponents != null) {
                for (int ei = 0; ei < rangeComponents.getLength(); ++ei) {
                    mergedComponents.add((Element)rangeComponents.item(ei));
                }
            }
            int index = mergedComponents.size();
            if (rangeComponents2 != null) {
                for (int ii = 0; ii < rangeComponents2.getLength(); ++ii) {
                    mergedComponents.add(index + ii, (Element)rangeComponents2.item(ii));
                }
            }
            int rangeLength = mergedComponents.size();
            for (int jj = 0; jj < rangeLength; ++jj) {
                Element rangeNode = (Element)mergedComponents.get(jj);
                if (rangeNode.getNodeType() != 1 || !rangeNode.hasAttributes()) continue;
                if (!rangeNode.getAttribute("Max").equals("")) {
                    return rangeNode.getAttribute("Max");
                }
                return rangeNode.getAttribute("max");
            }
        }
        return null;
    }

    public String getMinValue(String fieldName) {
        FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fieldDefinition != null && fieldDefinition.hasUtil("EditComponent") && "ericsson.ere.gui.util.NumberRangeEditor".equals(fieldDefinition.getUtilClass("EditComponent")) || fieldDefinition != null && fieldDefinition.hasUtil("InputRestriction") && "Range".equals(fieldDefinition.getUtilClass("InputRestriction"))) {
            Element editComponentElement = XMLUtil.getNamedElement("EditComponent", fieldDefinition.getDefinitionNode().getChildNodes());
            NodeList rangeComponents = null;
            if (editComponentElement != null) {
                rangeComponents = editComponentElement.getElementsByTagName("Range");
            }
            Element inputRestrictionElement = XMLUtil.getNamedElement("InputRestriction", fieldDefinition.getDefinitionNode().getChildNodes());
            NodeList rangeComponents2 = null;
            ArrayList<Element> mergedComponents = new ArrayList<Element>();
            if (inputRestrictionElement != null) {
                rangeComponents2 = inputRestrictionElement.getElementsByTagName("Range");
            }
            if (rangeComponents != null) {
                for (int ei = 0; ei < rangeComponents.getLength(); ++ei) {
                    mergedComponents.add((Element)rangeComponents.item(ei));
                }
            }
            int index = mergedComponents.size();
            if (rangeComponents2 != null) {
                for (int ii = 0; ii < rangeComponents2.getLength(); ++ii) {
                    mergedComponents.add(index + ii, (Element)rangeComponents2.item(ii));
                }
            }
            int rangeLength = mergedComponents.size();
            for (int jj = 0; jj < rangeLength; ++jj) {
                Element rangeNode = (Element)mergedComponents.get(jj);
                if (rangeNode.getNodeType() != 1 || !rangeNode.hasAttributes()) continue;
                if (!rangeNode.getAttribute("Min").equals("")) {
                    return rangeNode.getAttribute("Min");
                }
                return rangeNode.getAttribute("min");
            }
        }
        return null;
    }

    public String getDataTypeAsInClassRepository(String tdf) {
        FieldDefinition myDefinition = this.myClassRepository.getFieldDefinitionByName(tdf);
        if (myDefinition == null) {
            return null;
        }
        return myDefinition.getDataType();
    }

    public static ArrayModel createEmptyArrayModelOfDataType(DataType dataType) {
        TDFAdditionalDataType adt = TDFAdditionalDataType.getByDataType(dataType);
        return new ArrayModel(new Object[]{new String[0], adt.getNativeDataType().createArray()}, TreeDefinedFieldDefs.COLUMN_NAMES);
    }

    public static String getDataTypeAsString(int dataType) {
        return EreDefs.getDataTypeFromIntValue(dataType);
    }

    public static int getDataType(String dataType) {
        return EreDefs.getDataType(dataType);
    }

    public Variable getVariable(TDFAdditionalObject additionalObject) {
        Variable variable = this.getVariableOfDataType(additionalObject.getDataType(), additionalObject.getName(), null, null, null, true);
        if (variable == null && TDFAdditionalType.DROPDOWN == additionalObject.getAdditionalType()) {
            variable = new TDFDropDownVariable(additionalObject.getName(), (Object)additionalObject.getDefaultValue(), additionalObject.getChoices());
        }
        return variable;
    }
}

